/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <Msi.h>
#include "jni.h"

JNIEXPORT jint JNICALL Java_org_simantics_db_procore_server_environment_windows_Msi_MsiQueryProductState0(
		JNIEnv* env, jclass clazz, jstring productCode
) {
	int result;
	const jchar* lpProductCode;

	lpProductCode = (*env)->GetStringChars(env, productCode, NULL);
	if (lpProductCode == 0)
		return 0;

	result = MsiQueryProductState((LPCTSTR) lpProductCode);

	(*env)->ReleaseStringChars(env, productCode, lpProductCode);

	return (jint) result;
}
