/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.tester;

import org.simantics.Simantics;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.Testers;
import org.simantics.browsing.ui.graph.tester.EqualsResourceTester;
import org.simantics.browsing.ui.graph.tester.HasRelatedObjectsTester;
import org.simantics.browsing.ui.graph.tester.HasSomeTypeTester;
import org.simantics.browsing.ui.graph.tester.InheritsSomeTypeTester;
import org.simantics.browsing.ui.graph.tester.OrderedSetTester;
import org.simantics.browsing.ui.graph.tester.StandardContextHasSomeTypeTester;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public final class GraphTesters {
    public static Tester pass() {
        return Testers.PASS;
    }

    public static Tester fail() {
        return Testers.FAIL;
    }

    public static Tester type(String uri) {
        try {
            return GraphTesters.type(Simantics.getSession(), uri);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return GraphTesters.fail();
        }
    }

    public static Tester standardContextType(String uri) {
        try {
            return GraphTesters.standardContextType(Simantics.getSession(), uri);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return GraphTesters.fail();
        }
    }

    public static Tester standardContextType(Session s, String uri) throws DatabaseException {
        return new StandardContextHasSomeTypeTester((RequestProcessor)s, uri);
    }

    public static Tester type(Session s, String uri) throws DatabaseException {
        return new HasSomeTypeTester((RequestProcessor)s, uri);
    }

    public static Tester type(Resource resource) {
        return new HasSomeTypeTester(resource);
    }

    public static Tester resource(String uri) {
        try {
            return GraphTesters.resource(Simantics.getSession(), uri);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return GraphTesters.fail();
        }
    }

    public static Tester resource(Session s, String uri) throws DatabaseException {
        return new EqualsResourceTester((RequestProcessor)s, uri);
    }

    public static Tester resource(Resource resource) {
        return new EqualsResourceTester(resource);
    }

    public static Tester inherits(Resource resource) {
        return new InheritsSomeTypeTester(resource);
    }

    public static Tester model() throws DatabaseException {
        Session s = Simantics.getSession();
        SimulationResource SIMU = SimulationResource.getInstance((RequestProcessor)s);
        return new HasSomeTypeTester(SIMU.Model);
    }

    public static Tester type() {
        return new HasSomeTypeTester(((Layer0)Simantics.getSession().getService(Layer0.class)).Type);
    }

    public static Tester orderedSet() {
        return new OrderedSetTester(Simantics.getSession());
    }

    public static Tester orderedSet(Session s) {
        return new OrderedSetTester(s);
    }

    public static Tester hasRelatedObjects(Resource relation) {
        return new HasRelatedObjectsTester(relation);
    }

    public static Tester hasRelatedObjects(RequestProcessor processor, String relationUri) throws DatabaseException {
        return new HasRelatedObjectsTester(processor, relationUri);
    }

    public static Tester hasRelatedObjects(String relationUri) {
        try {
            return GraphTesters.hasRelatedObjects((RequestProcessor)Simantics.getSession(), relationUri);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return GraphTesters.fail();
        }
    }
}

