/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.search;

import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;

public class NamedResource {
    private final Resource resource;
    private final String resourceText;
    private final String name;
    private final String uri;

    public static NamedResource of(ReadGraph graph, Resource resource) throws DatabaseException {
        return NamedResource.of(graph, resource, NameLabelUtil.modalName((ReadGraph)graph, (Resource)resource));
    }

    public static NamedResource of(ReadGraph graph, Resource resource, String name) throws DatabaseException {
        return NamedResource.of((ServiceLocator)graph, resource, name, graph.getPossibleURI(resource));
    }

    public static NamedResource of(ServiceLocator locator, Resource resource, String name, String uri) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)locator.getService(SerialisationSupport.class);
        return new NamedResource(resource, "" + ss.getRandomAccessId(resource), name, uri);
    }

    public NamedResource(String resourceText, String name, String uri) {
        this(null, resourceText, name, uri);
    }

    public NamedResource(Resource resource, String resourceText, String name, String uri) {
        this.resource = resource;
        this.resourceText = resourceText;
        this.name = name;
        this.uri = uri;
    }

    public Resource getResourceDB() {
        if (this.resource == null) {
            throw new NullPointerException("null Resource in NamedResource(" + this.resourceText + ", " + this.name + ", " + this.uri + ")");
        }
        return this.resource;
    }

    public Resource getPossibleResourceDB() {
        return this.resource;
    }

    public String getResource() {
        return this.resourceText;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }
}

