package org.simantics.workbench.search;

import java.util.ArrayList;
import java.util.List;


/**
 * Search result.
 * 
 * @author Marko Luukkainen
 */
public class SearchResult {

	public List<SearchResultColumn> columns;
    public List<SearchResultRow> rows;
    
    public SearchResult() {
		columns = new ArrayList<SearchResultColumn>();
		rows = new ArrayList<SearchResultRow>();
	}

    public SearchResult(List<SearchResultColumn> columns) {
		this.columns = columns;
		rows = new ArrayList<SearchResultRow>();
	}
    
    public void addColumn(SearchResultColumn column) {
    	columns.add(column);
    }
    
    public void addRow(SearchResultRow row) {
    	rows.add(row);
    }
    
    public List<SearchResultColumn> getColumns() {
		return columns;
	}
    
    public List<SearchResultRow> getRows() {
		return rows;
	}
    
    public int columnCount() {
    	return columns.size();
    }
    
    public int rowCount() {
    	return rows.size();
    }
    
    public SearchResult subset(int start, int end) {
    	SearchResult copy = new SearchResult(columns);
    	copy.rows = rows.subList(start, end);
    	return copy;
    }
    
    public boolean isEmpty() {
    	return rows.isEmpty();
    }

}
