package org.simantics.workbench.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.databoard.util.URIStringUtils;

/**
 * Search Result for Name and Type queries.
 * 
 * Implements the functionality of old SearchResult used in Simantics 1.10 and 1.11
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class NameAndTypeRow implements SearchResultRow {
	
	public static final List<SearchResultColumn> columns;
	
	static {
		columns = new ArrayList<SearchResultColumn>();
		columns.add(new SearchResultColumn("Name"));
		columns.add(new SearchResultColumn("Type"));
		columns.add(new SearchResultColumn("Part Of"));
	}
	
	public NamedResource             resource;
    public NamedResource             parent;
    public Collection<NamedResource> types;
    public Collection<NamedResource> principalTypes;

    public NamedResource getResource() {
        return resource;
    }

    public NamedResource getParent() {
        return parent;
    }

    public Collection<NamedResource> getTypes() {
        return types;
    }

    public Collection<NamedResource> getPrincipalTypes() {
        return principalTypes;
    }
    
    @Override
    public String getContent(int column) {
    	
    	switch (column) {
    	
		case 0:
			return "<a class=\"small\" href=\"resource:"+ resource.getResource() +"\"" + (resource.getUri() == null ? "" : " title=\""+URIStringUtils.unescape( resource.getUri() ))+"\">"+StringUtil.escape(resource.getName())+"</a>";
		case 1:
			String s = "";
			for (NamedResource type : principalTypes)
			 s+="<a class=\"small\" href=\"resource:"+ type.getResource() +"\"" + (type.getUri() == null ? "" : " title=\""+URIStringUtils.unescape( type.getUri() ))+"\">"+StringUtil.escape(type.getName())+"</a>";
			return s;
		case 2:
			if (parent != null)
				return "<a class=\"small\" href=\"resource:"+ parent.getResource() +"\"" + (parent.getUri() == null ? "" : " title=\""+URIStringUtils.unescape( parent.getUri() ))+"\">"+StringUtil.escape(parent.getName())+"</a>";
			return "";
		default:
			return "";
		}
    }
}
