/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.IResourceEditorInput;

public class TitleWithParentNameRequest
extends UnaryRead<IResourceEditorInput, String> {
    public TitleWithParentNameRequest(IResourceEditorInput input) {
        super((Object)input);
    }

    public String perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource r = ((IResourceEditorInput)this.parameter).getResource();
        Resource parent = graph.getPossibleObject(r, L0.PartOf);
        String name = this.safeName(graph, r, "No name", L0);
        String parentName = this.safeName(graph, parent, "No parent", L0);
        return name + " (" + parentName + ")";
    }

    protected String safeName(ReadGraph graph, Resource r, String noNameValue, Layer0 L0) throws DatabaseException {
        String name;
        if (r != null && (name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING)) != null) {
            return name;
        }
        return noNameValue;
    }
}

