/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.ui.workbench.IPerspectiveContextExtension;
import org.simantics.utils.datastructures.MapList;

public class PerspectiveContextBindingManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.ui";
    private static final String EP_NAME = "perspectiveContextBinding";
    private ExtensionTracker tracker;
    private MapList<String, IPerspectiveContextExtension> extensions = new MapList();
    private static PerspectiveContextBindingManager INSTANCE;

    public static synchronized PerspectiveContextBindingManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PerspectiveContextBindingManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private PerspectiveContextBindingManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new MapList();
    }

    public synchronized List<IPerspectiveContextExtension> getExtensions(String perspectiveId) {
        List exts = this.extensions.getValues((Object)perspectiveId);
        if (exts == null) {
            return Arrays.asList(new IPerspectiveContextExtension[0]);
        }
        return Collections.unmodifiableList(exts);
    }

    private synchronized void loadExtensions(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String perspectiveId = el.getAttribute("perspectiveId");
            String contextId = el.getAttribute("contextIds");
            String[] contextIds = contextId.split(",");
            IPerspectiveContextExtension.Stub ext = new IPerspectiveContextExtension.Stub(perspectiveId, contextIds);
            this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
            this.extensions.add((Object)perspectiveId, (Object)ext);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public synchronized void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IPerspectiveContextExtension ext = (IPerspectiveContextExtension)o;
            this.tracker.unregisterObject(extension, (Object)ext);
            this.extensions.remove((Object)ext.getPerspectiveId(), (Object)ext);
            ++n2;
        }
    }
}

