/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public abstract class AbstractEditorAdapter implements EditorAdapter, Prioritized {

    protected String          name;

    protected ImageDescriptor icon;

    protected int             priority;

    public AbstractEditorAdapter(String name) {
        this(name, null, 0);
    }

    public AbstractEditorAdapter(String name, ImageDescriptor icon) {
        this(name, icon, 0);
    }

    public AbstractEditorAdapter(String name, ImageDescriptor icon, int priority) {
        this.name = name;
        this.icon = icon;
        this.priority = priority;
    }

    public String getName() {
        return name;
    }

    public ImageDescriptor getIcon() {
        return icon;
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected void setIcon(ImageDescriptor icon) {
        this.icon = icon;
    }

    protected void openEditorWithId(String editorId, IEditorInput input) throws PartInitException {
        WorkbenchUtils.openEditor(editorId, input);
    }

    protected void openEditorWithIdInPerspective(String editorId, IEditorInput input, String perspectiveId)
    throws WorkbenchException {
        try {
            WorkbenchUtils.showPerspective(perspectiveId);
        } catch (WorkbenchException e) {
            ErrorLogger.getDefault().logError("Could not open perspective with ID'" + perspectiveId + "'.", e);
        }

        openEditorWithId(editorId, input);
    }

}