/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.simantics.db.event.ChangeListener;

/**
 * ResourceEditorPart2 is a base implementation for editors that support
 * {@link IResourceEditorInput2} style inputs for working on top of the
 * Simantics graph database.
 * 
 * <p>
 * If you want your ResourceEditorPart2 implementation to receive notifications
 * for all graph change events through the {@link ChangeListener} interface,
 * just implement it and it will be automatically invoked by this base
 * implementation.
 * </p>
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ResourceEditorPart
 */
public abstract class ResourceEditorPart2 extends ResourceEditorPart implements IResourceEditorPart2 {

    @Override
    public IResourceEditorInput2 getResourceInput2() {
        return (IResourceEditorInput2) getEditorInput();
    }

}
