/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench;

import org.eclipse.ui.IEditorInput;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 * 
 * @see ResourceEditorInput2
 */
public interface IResourceEditorInput2 extends IEditorInput, IResourceEditorInput {

    /**
	 * This is a base URI, not a model URI but the name of the method cannot be
	 * changed now. If {@link #getRVI()} returns <code>null</code>, this URI
	 * should be used as such to get a {@link Variable} view of the input.
	 * 
	 * @return URI of the model the input is related to or <code>null</code> if
	 *         no model is available
	 */
//    String getModelURI();

    Resource getModel(ReadGraph graph);
    
    /**
	 * @return a {@link Variable} Relative Variable Identifier (RVI). May be an
	 *         empty string or <code>null</code> if {@link #getModelURI()}
	 *         should be interpreted as the absolute {@link Variable} URI of the
	 *         input.
	 */
    String getRVI();

    /**
     * Adapt this editor input into a {@link Variable} outside of a database
     * transaction.
     * 
     * @return
     * @throws DatabaseException if variable adaption fails
     * @since 1.6
     */
    Variable getVariable() throws DatabaseException;

    /**
     * Adapt this editor input into a {@link Variable} within a database
     * transaction.
     * 
     * @param graph
     * @return
     * @throws DatabaseException if variable adaption fails
     * @since 1.6
     */
    Variable getVariable(ReadGraph graph) throws DatabaseException;

}
