package org.simantics.ui.selection;

import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ResourceVariable;

public class ResourceWorkbenchSelectionElement implements WorkbenchSelectionElement {

    final private Resource resource;

    public ResourceWorkbenchSelectionElement(Resource resource) {
        this.resource = resource;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
        if(contentType instanceof AnyResource) {
            return (T)resource;
        } else if(contentType instanceof AnyVariable) {
            AnyVariable type = (AnyVariable)contentType;
            try {
                return (T) type.processor.sync(new ResourceVariable(resource));
            } catch (DatabaseException e) {
                Logger.defaultLogError(e);
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        return resource.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof ResourceWorkbenchSelectionElement))
            return false;
        ResourceWorkbenchSelectionElement vwse = (ResourceWorkbenchSelectionElement)object;
        return resource.equals(vwse.resource);
    }

}
