/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.ui.workbench.StringMemento;

/**
 * @author Toni Kalajainen
 */
public class ResourceTransferUtils {

    public static String createStringTransferable(Session s, ResourceArray resources[])
    throws DatabaseException
    {
        return createStringTransferable(s, resources, null);
    }

    public static String createStringTransferable(Session s, ResourceArray resources[], String purpose)
    throws DatabaseException
    {
        SerialisationSupport support = s.getService(SerialisationSupport.class);
        StringMemento memento = new StringMemento();
        ResourceTransferData transferData = new ResourceTransferData(s, resources);
        transferData.setPurpose(purpose);
        transferData.writeToMemento(support, memento);
        String strData = memento.toString();
        return strData;
    }

    public static String createStringTransferable(SerialisationSupport serializer, ResourceTransferData transferData)
    throws DatabaseException
    {
        StringMemento memento = new StringMemento();
        transferData.writeToMemento(serializer, memento);
        String strData = memento.toString();
        return strData;
    }

    public static Transferable createAwtTransferable(SerialisationSupport serializer, ResourceTransferData transferData)
    throws DatabaseException
    {
        String strData = createStringTransferable(serializer, transferData);
        return new StringSelection(strData);
    }

    public static TransferData createSwtTextTransferData(SerialisationSupport serializer, ResourceTransferData transferable)
    throws DatabaseException
    {
        String strData = createStringTransferable(serializer, transferable);
        TransferData transferData = new TransferData();
        TextTransfer.getInstance().javaToNative(strData, transferData);
        return transferData;
    }

    public static ResourceTransferData readStringTransferable(SerialisationSupport serializer, String strData)
    throws IllegalArgumentException, DatabaseException
    {
        StringMemento sm = new StringMemento(strData);
        ResourceTransferData result = new ResourceTransferData();
        result.readFromMemento(serializer, sm);
        return result;
    }

    public static ResourceTransferData readAwtTransferable(SerialisationSupport serializer, Transferable transferable)
    throws UnsupportedFlavorException, IOException, IllegalArgumentException, DatabaseException
    {
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor))
            throw new UnsupportedFlavorException(DataFlavor.stringFlavor);

        String dropData = (String) transferable.getTransferData(DataFlavor.stringFlavor);
        ResourceTransferData result = readStringTransferable(serializer, dropData);
        return result;
    }

    public static ResourceTransferData readSwtTextTransferable(SerialisationSupport serializer, TransferData transferData)
    throws IOException, IllegalArgumentException, DatabaseException
    {
        if (!TextTransfer.getInstance().isSupportedType(transferData))
            throw new IllegalArgumentException("argument is not text transfer");
        String dropData = TextTransfer.getInstance().nativeToJava(transferData).toString();
        ResourceTransferData result = readStringTransferable(serializer, dropData);
        return result;
    }

}
