package org.simantics.ui.contribution;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * A replacement interface that a {@link DynamicMenuContribution} implementation
 * can implement to optimize away unnecessary ISelection conversions.
 * 
 * <p>
 * This interface exists to keep backwards compatible with old
 * {@link DynamicMenuContribution} implementations but allow for optimizations
 * where needed.
 * 
 * @author TuukkaLehtonen
 * @since 1.48.0
 */
public interface IDynamicMenuContribution2 {

	/**
	 * Tests the input selection for whether it can produce any meaningful
	 * contribution items in the first place. This is a filter that is invoked
	 * before performing a database request to find out more about the possible
	 * contributions.
	 * 
	 * <p>
	 * The default implementation checks that the input selection is not empty. To
	 * be able to provide contributions for empty selection, you must override this
	 * method.
	 * 
	 * @param selection
	 * @return <code>true</code> if selection is {@link IStructuredSelection} and
	 *         non-empty
	 */
	default boolean preAcceptSelection2(ISelection selection) {
		return selection instanceof IStructuredSelection
				? !((IStructuredSelection) selection).isEmpty()
				: false;
	}

	default IContributionItem[] getContributionItems2(ReadGraph graph, ISelection selection) throws DatabaseException {
		return DynamicMenuContribution.toContributionItems(getActions2(graph, selection));
	}

	default IAction[] getActions2(ReadGraph graph, ISelection selection) throws DatabaseException {
		throw new UnsupportedOperationException("Not implemented");
	}

}