/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.auth;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.simantics.ui.auth.model.LoginModel;

/**
 * @author Tuukka Lehtonen
 */
public class LoginComposite extends Composite {

//    private FormToolkit toolkit;

    private LoginModel  model;

    public LoginComposite(Composite parent, int style, LoginModel m) {
        super(parent, style);
        
        this.model = m;

//        toolkit = new FormToolkit(parent.getDisplay());

        Composite body = this;
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(body);

        Label desc = new Label(this, 0);
        desc.setText("Enter credentials for " + model.getServer().getInfo());
        GridDataFactory.fillDefaults().span(2, 1).applyTo(desc);
        
//        Label nameLabel = toolkit.createLabel(this, "User name:");
        Label nameLabel = new Label(this, 0);
        nameLabel.setText("&User name:");
        GridDataFactory.fillDefaults().align(SWT.LEAD, SWT.CENTER).applyTo(nameLabel);
//        final Text nameText = toolkit.createText(this, "", SWT.NONE);
        final Text nameText = new Text(this, SWT.BORDER);
        nameText.setText(model.getName());
        GridDataFactory.fillDefaults().grab(true, false).applyTo(nameText);

//        Label passwordLabel = toolkit.createLabel(this, "Password:");
        Label passwordLabel = new Label(this, 0);
        passwordLabel.setText("&Password:");
        GridDataFactory.fillDefaults().align(SWT.LEAD, SWT.CENTER).applyTo(passwordLabel);
//        final Text passwordText = toolkit.createText(this, "", SWT.NONE);
        final Text passwordText = new Text(this, SWT.PASSWORD | SWT.BORDER);
        passwordText.setText(model.getPassword());
        GridDataFactory.fillDefaults().grab(true, false).applyTo(passwordText);

//        final Button rememberButton = toolkit.createButton(this, "Remember Login", SWT.CHECK);
        final Button rememberButton = new Button(this, SWT.CHECK);
        rememberButton.setText("&Remember Login");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo(rememberButton);
        
        // Build the separator line
        Label separator = new Label(this, SWT.HORIZONTAL | SWT.SEPARATOR);
        GridDataFactory.fillDefaults().align(SWT.FILL, SWT.BOTTOM).span(2, 1).grab(false, true).applyTo(separator);
        
        nameText.addModifyListener(new ModifyListener() {
            @Override
            public void modifyText(ModifyEvent e) {
                model.setName(nameText.getText());
            }
        });
        passwordText.addModifyListener(new ModifyListener() {
            @Override
            public void modifyText(ModifyEvent e) {
                model.setPassword(passwordText.getText());
            }
        });
        rememberButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                model.setRemember(rememberButton.getSelection());
            }
        });
        
        new FocusSelector(nameText);
        new FocusSelector(passwordText);
    }
    
    static class FocusSelector implements FocusListener {
        Text text;
        FocusSelector(Text text) {
            this.text = text;
            text.addFocusListener(this);
        }
        @Override
        public void focusGained(FocusEvent e) {
            text.selectAll();
        }
        @Override
        public void focusLost(FocusEvent e) {
            text.setSelection(0);
        }
    }

    @Override
    public void dispose() {
        if (isDisposed()) {
//            if (toolkit != null) {
//                toolkit.dispose();
//                toolkit = null;
//            }
            super.dispose();
        }
    }

}
