/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.trend.impl.Plot;
import org.simantics.trend.impl.TrendNode;

public class SelectionNode
extends G2DNode {
    private static final long serialVersionUID = -8803833805847402592L;
    public static AlphaComposite composite = AlphaComposite.getInstance(3, 0.5f);
    public static final Color COLOR = new Color(0.5f, 0.5f, 1.0f);
    public static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 2, 10.0f, null, 0.0f);
    double x1;
    double x2;
    double y1;
    double y2;
    Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    Rectangle2D.Double rect2 = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    boolean binaryZoom = false;
    boolean timeZoom = false;

    public void start(Point2D pt, boolean binaryZoom, boolean timeZoom) {
        this.x1 = this.x2 = pt.getX();
        this.y1 = this.y2 = pt.getY();
        this.rect.setFrame(this.x1, this.y1, 0.0, 0.0);
        this.rect2.setFrame(this.x1, this.y1, 0.0, 0.0);
        this.binaryZoom = binaryZoom;
        this.timeZoom = timeZoom;
    }

    public void setEndPoint(Point2D pt) {
        this.x2 = pt.getX();
        this.y2 = pt.getY();
        this.layout();
    }

    public void layout() {
        TrendNode trend = (TrendNode)this.getParent();
        if (trend == null) {
            return;
        }
        Plot plot = trend.plot;
        if (this.binaryZoom) {
            double px = plot.getX();
            double py = plot.getY() + plot.analogAreaHeight;
            double pw = plot.getWidth();
            double ph = plot.binaryAreaHeight;
            this.rect2.setFrame(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
            double _x1 = Math.min(Math.max(this.x1, px), px + pw);
            double _x2 = Math.min(Math.max(this.x2, px), px + pw);
            this.rect.setFrame(Math.min(_x1, _x2), py, Math.abs(_x1 - _x2), ph);
        } else {
            double px = plot.getX();
            double py = plot.getY();
            double pw = plot.getWidth();
            double ph = plot.analogAreaHeight;
            this.rect2.setFrame(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
            double _x1 = Math.min(Math.max(this.x1, px), px + pw);
            double _x2 = Math.min(Math.max(this.x2, px), px + pw);
            double _y1 = Math.min(Math.max(this.y1, py), py + ph);
            double _y2 = Math.min(Math.max(this.y2, py), py + ph);
            if (this.timeZoom) {
                this.rect.setFrame(Math.min(_x1, _x2), py, Math.abs(_x1 - _x2), plot.analogAreaHeight);
            } else {
                this.rect.setFrame(Math.min(_x1, _x2), Math.min(_y1, _y2), Math.abs(_x1 - _x2), Math.abs(_y1 - _y2));
            }
        }
    }

    public void render(Graphics2D g2d) {
        Composite c = g2d.getComposite();
        g2d.setComposite(composite);
        g2d.setColor(COLOR);
        g2d.fill(this.rect);
        g2d.setComposite(c);
        g2d.setStroke(STROKE);
        g2d.draw(this.rect);
    }

    public Rectangle2D getBoundsInLocal() {
        return this.rect;
    }
}

