package org.simantics.structural2.variables;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

/**
 * TODO: consider removing this, doesn't seem to be used
 */
public class MutablePropertyVariable extends AbstractPropertyVariable {

    final protected Variable parent;
    final String name;

    public Object value;
    public Binding binding;
    
    public MutablePropertyVariable(Variable parent, String name) {
        assert parent != null;
        assert name != null;
        this.parent = parent;
        this.name = name;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        return (T)value;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getValue(ReadGraph graph, Binding binding)
            throws DatabaseException {
        return (T)value;
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding)
            throws DatabaseException {
        throw new DatabaseException("Value is constant.");
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return name;
    }

    @Override
    public Resource getType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getPossibleType(ReadGraph graph) throws DatabaseException {
        return null;
    }

    @Override
    public Resource getType(ReadGraph graph, Resource baseType)throws DatabaseException {
        return null;
    }

    @Override
    public Resource getPossibleType(ReadGraph graph, Resource baseType) throws DatabaseException {
    	return null;
    }

//    @Override
//    public Object getSerialized(ReadGraph graph) throws DatabaseException {
//        return name;
//    }

    @Override
    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return parent;
    }

    @Override
    public Resource getRepresents(ReadGraph graph) throws DatabaseException {
        return null;
    }
    
    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return binding != null ? binding.type() : null;
    }
    
    @Override
    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
    	return null;
    }

    @Override
    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
    	return null;
    }
    
    @Override
    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
    	return null;
    }
    
    @Override
    protected Variable getPossibleDomainProperty(ReadGraph graph, String name)
    		throws DatabaseException {
    	return null;
    }

    @Override
    public Map<String, Variable> collectDomainProperties(ReadGraph graph,
    		Map<String, Variable> properties) throws DatabaseException {
    	return properties;
    }
    
    @Override
    public Set<String> getClassifications(ReadGraph graph) throws DatabaseException {
    	Variable property = getPossibleDomainProperty(graph, Variables.CLASSIFICATIONS);
    	if(property != null) return property.getValue(graph);
    	else return Collections.emptySet();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + name.hashCode();
        result = prime * result + parent.hashCode();
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        result = prime * result + ((binding == null) ? 0 : binding.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MutablePropertyVariable other = (MutablePropertyVariable) obj;
        if (!name.equals(other.name))
            return false;
        if (!parent.equals(other.parent))
            return false;
        if (!Objects.equals(value, other.value))
            return false;
        return Objects.equals(binding, other.binding);
    }

}
