package org.simantics.structural2.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;

public class SCLMainModuleRequest extends UnaryRead<Resource, String> {

	public SCLMainModuleRequest(Resource indexRoot) {
		super(indexRoot);
	}

	@Override
	public String perform(ReadGraph graph) throws DatabaseException {
		if(parameter == null) return null;
		Resource mainModule = Layer0Utils.getPossibleChild(graph, parameter, "SCLMain");
		if(mainModule != null) {
			return graph.getURI(mainModule);
		}
		return null;
	}

}
