package org.simantics.structural2.queries;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.IsSubrelationOf;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.structural.stubs.StructuralResource2;

public class PossibleConnectionPointInfo extends ResourceRead<PropertyInfo> {

	public PossibleConnectionPointInfo(Resource resource) {
		super(resource);
	}

	@Override
	public PropertyInfo perform(ReadGraph graph) throws DatabaseException {

		PropertyInfo info = graph.syncRequest(new PropertyInfoRequest(resource), TransientCacheAsyncListener.<PropertyInfo>instance());
		if(info != null && !info.isHasProperty) {
			StructuralResource2 STR = StructuralResource2.getInstance(graph);
			if(graph.syncRequest(new IsSubrelationOf(resource, STR.IsConnectedTo), TransientCacheAsyncListener.<Boolean>instance())) {
				if (info.name != null) return info;
			}
		}
		return null;
		
	}

}
