/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.ModelingResources;
import org.simantics.selectionview.CategoryNodeImpl;
import org.simantics.selectionview.SelectionViewUtils;

public class VariablePropertyCategoryRule
implements ChildRule {
    private final ArrayList<String> requiredProperties = new ArrayList();
    final Resource rule;

    public VariablePropertyCategoryRule(ReadGraph graph, Resource rule) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(rule, MOD.ModelingBrowseContext_VariablePropertyRule_RequireProperty)) {
            String name = (String)graph.getValue(r, (Binding)Bindings.STRING);
            this.requiredProperties.add(name);
        }
        this.rule = rule;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        HashSet<CategoryNodeImpl> result = null;
        Collection<Variable> properties = SelectionViewUtils.extractProperties(graph, (Variable)parent);
        block0: for (Variable property : properties) {
            String name;
            Boolean hidden;
            for (String req : this.requiredProperties) {
                if (property.getPossibleProperty(graph, req) == null) continue block0;
            }
            Variable info = property.getPossibleProperty(graph, "HasStandardPropertyInfo");
            if (info == null) continue;
            Variable special = SelectionViewUtils.getSpecialCategory(graph, this.rule, info);
            if (special != null) {
                info = special;
            }
            if ((hidden = (Boolean)info.getPossiblePropertyValue(graph, "IsHidden", (Binding)Bindings.BOOLEAN)) != null && hidden.booleanValue() || (name = (String)info.getPossiblePropertyValue(graph, "CategoryName", (Binding)Bindings.STRING)) == null) continue;
            String sortName = (String)info.getPossiblePropertyValue(graph, "CategorySortingName", (Binding)Bindings.STRING);
            if (result == null) {
                result = new HashSet<CategoryNodeImpl>();
            }
            result.add(new CategoryNodeImpl(name, sortName));
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return Collections.emptyList();
    }
}

