/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.selectionview.SelectionViewResources;

public class SelectionViewUtils {
    public static Variable getSpecialCategory(ReadGraph graph, Resource rule, Variable info) throws DatabaseException {
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Variable property = info.getParent(graph);
        Variable parent = property.getParent(graph);
        if (Variables.Role.PROPERTY.equals((Object)parent.getPossibleRole(graph))) {
            return null;
        }
        Resource predicate = property.getPossiblePredicateResource(graph);
        Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)rule);
        Function1 getSpecialCategory = (Function1)ruleVariable.getPossiblePropertyValue(graph, SEL.getSpecialCategory);
        if (getSpecialCategory == null) {
            return null;
        }
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            sclContext.put((Object)"graph", (Object)graph);
            Resource cat = (Resource)getSpecialCategory.apply((Object)predicate);
            if (cat != null) {
                Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)cat);
                return variable;
            }
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
        return null;
    }

    public static Collection<Variable> extractPropertiesRec(ReadGraph graph, Variable parent, Collection<Variable> result) throws DatabaseException {
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        for (Variable property : parent.getProperties(graph)) {
            Boolean flatten = (Boolean)property.getPossiblePropertyValue(graph, SEL.flatten, (Binding)Bindings.BOOLEAN);
            if (flatten != null && flatten.booleanValue()) {
                result = SelectionViewUtils.extractPropertiesRec(graph, property, result);
                continue;
            }
            if (result == null) {
                result = new ArrayList<Variable>();
            }
            result.add(property);
        }
        return result;
    }

    public static Collection<Variable> extractProperties(ReadGraph graph, Variable parent) throws DatabaseException {
        Collection<Variable> result = SelectionViewUtils.extractPropertiesRec(graph, parent, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }
}

