/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import java.util.List;

import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.EnumerationVariableModifier3;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.browsing.ui.model.modifiers.VariableModifier2;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

/**
 * @author Tuukka Lehtonen
 */
public class VariablePropertyModifierRule implements ModifierRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Modifier getModifier(ReadGraph graph, Object _content, String columnKey_) throws DatabaseException {

        if (!(_content instanceof Variable))
            return null;

        Variable content = (Variable)_content;

        // If the whole property is considered read-only, don't allow modification.
        Boolean readOnly = content.getPossiblePropertyValue(graph, Variables.READONLY);
        if (Boolean.TRUE.equals(readOnly))
            return null;
        
        String columnKey = columnKey_;
        if(columnKey.startsWith("#")) columnKey = columnKey.substring(1);

        // If the specified column of the property is considered read-only, don't allow modification.
        Variable columnVariable = content.getPossibleProperty(graph, columnKey);
        if (columnVariable != null) {
            readOnly = columnVariable.getPossiblePropertyValue(graph, Variables.READONLY);
            if (Boolean.TRUE.equals(readOnly))
                return null;
        }

        for (Variable property : content.getProperties(graph)) {
            String column = property.getPossiblePropertyValue(graph, Variables.DISPLAY_COLUMN);
            if (column != null) {
                if (columnKey.equals(column)) {
                	
                	if(columnKey_.startsWith("#"))
                        return new VariableModifier2(graph, property);

                    Modifier custom = property.getPossiblePropertyValue(graph, Variables.CUSTOM_MODIFIER);
                    if (custom != null) return custom;

                    List<String> enumeration = property.getPossiblePropertyValue(graph, Variables.ENUMERATION_VALUES);
                    if (enumeration != null) {
                        return new EnumerationVariableModifier3(graph, property, enumeration);
                    } else {
                        return new VariableModifier2(graph, property);
                    }

                }
            }
        }

        return null;

    }

}
