package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.layer0.variable.Variables.Role;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SelectionViewUtils {

	public static Variable getSpecialCategory(ReadGraph graph, Resource rule, Variable info) throws DatabaseException {

		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);

		Variable property = info.getParent(graph);
		Variable parent = property.getParent(graph);
		if(Role.PROPERTY.equals(parent.getPossibleRole(graph))) return null;

		Resource predicate = property.getPossiblePredicateResource(graph);
		Variable ruleVariable = Variables.getVariable(graph, rule);

		Function1<Object,List<?>> getSpecialCategory = ruleVariable.getPossiblePropertyValue(graph, SEL.getSpecialCategory);
		if(getSpecialCategory == null) return null;

		SCLContext sclContext = SCLContext.getCurrent();
		Object oldGraph = sclContext.get("graph");
		try {
			sclContext.put("graph", graph);
			Resource cat = (Resource)getSpecialCategory.apply(predicate);
			if(cat != null) return Variables.getVariable(graph, cat);
		} catch (Throwable t) {
			throw new DatabaseException(t);
		} finally {
			sclContext.put("graph", oldGraph);
		}

		return null;

	}

	public static Collection<Variable> extractPropertiesRec(ReadGraph graph, Variable parent, Collection<Variable> result) throws DatabaseException {

		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);
		for(Variable property : parent.getProperties(graph)) {

			Boolean flatten = property.getPossiblePropertyValue(graph, SEL.flatten, Bindings.BOOLEAN);
			if(flatten != null && flatten) {
				result = extractPropertiesRec(graph, property, result);
			} else {
				if(result == null)
					result = new ArrayList<>();
				result.add(property);
			}
		}

		return result;

	}

	public static Collection<Variable> extractProperties(ReadGraph graph, Variable parent) throws DatabaseException {
		Collection<Variable> result = extractPropertiesRec(graph, parent, null);
		if(result == null)
			return Collections.emptyList();
		else
			return result; 
	}

}
