/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import java.util.function.Consumer;

import org.eclipse.jface.viewers.ISelection;


/**
 * @author Tuukka Lehtonen
 * 
 * @see PropertyTabAdapter
 * @see PropertyTabContributorImpl
 */
public interface IPropertyTab2 extends IPropertyTab {

    /**
     * @param updateCallback a callback that <em>can be</em> invoked by
     *        getPartName if it wishes to change the part name. If the page does
     *        not wish to change the part name, it does not have to invoke the
     *        updateCallback. A <code>null</code> value indicates that the part
     *        name should be returned to its default value. The method should
     *        use the selection received by
     *        {@link #setInput(org.simantics.db.management.ISessionContext, ISelection, boolean)}
     *        as input for constructing the part title.
     */
    void updatePartName(Consumer<String> updateCallback);

}