/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import java.util.function.Consumer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.simantics.browsing.ui.swt.InputValidators;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.VariableStringPropertyTextModifier;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleProperty;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.InputValidator;
import org.simantics.db.layer0.variable.InputValidatorFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.management.ISessionContext;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ISelectionUtils;

/*
 * 
 * @Deprecated in favor of ModelledTabContributor
 * 
 */
abstract public class ConfigurationComposite extends PropertyTabContributorImpl {

	protected FormToolkit toolkit;
	protected LocalResourceManager resourceManager;
	protected Font font;
	protected Font smallFont;
	protected Font smallFont2;

	ScrolledComposite explorersScroll;
	Composite explorers;

	public class ScrollListener implements Listener {

		public Control[] composites;

		final public int minSize;
		
		private boolean pending = false;

		public ScrollListener(int minSize) {
			this.minSize = minSize;
		}

		@Override
		public void handleEvent(Event event) {
			handleEvent();
		}

		public void handleEvent() {
			
			if(pending) return;
			
			pending = true;
			
			Display.getCurrent().asyncExec(new Runnable() {

				@Override
				public void run() {
					doHandleEvent();
				}
				
			});
			
		}

		public void doHandleEvent() {
			
			if(explorers == null || explorers.isDisposed()) return;
			
			pending = false;
			
			Point o = explorers.getSize();
			Point p = explorers.computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
			if(!o.equals(p)) {
				explorers.setSize(p);
			}

		}

	}

	protected ScrollListener listener;

	protected Composite createScroll(Composite body) {
		return createScroll(body, 1);
	}

	protected Composite createScroll(Composite body, int minSize) {
		return createScroll(body, minSize, 1);
	}

	protected Composite createScroll(Composite body, int minSize, int columnCount) {

		listener = new ScrollListener(minSize);

		explorersScroll = new ScrolledComposite(body, SWT.V_SCROLL | SWT.BORDER);
		explorersScroll.setBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_WHITE));
		explorersScroll.setLayout(GridLayoutFactory.fillDefaults()
				.margins(0, 0).spacing(0, 0).create());
		explorersScroll.setExpandVertical(false);
		explorersScroll.setExpandHorizontal(true);
		GridDataFactory.fillDefaults().grab(true, true).span(2, 1)
				.applyTo(explorersScroll);

		explorers = new Composite(explorersScroll, SWT.NONE);
		explorers.setBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_WHITE));
		// Make sure that exploders are visible
		explorers.setSize(10, 300);
		explorers.setLayout(GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(columnCount)
				.spacing(0, 0).create());
		GridDataFactory.fillDefaults().grab(false, false).applyTo(explorers);

		explorersScroll.setMinSize(100, 100);
		explorersScroll.setContent(explorers);

		return explorers;

	}

	protected void registerScrollExplorers(Control... composites) {

		listener.composites = composites;
		// listener.cache = new int[composites.length];

		for (Control composite : composites) {
			if (composite instanceof GraphExplorerComposite) {
				ScrollListener listener = this.listener;
				if (listener == null)
					listener = this.listener;
				Tree tree = ((GraphExplorerComposite) composite)
						.getExplorerControl();
				tree.addListener(SWT.SetData, listener);
//				tree.addListener(SWT.Resize, listener);
//				tree.addListener(SWT.Expand, listener);
//				tree.addListener(SWT.Collapse, listener);
			}
		}

	}

	protected Label createHeaderLabel(final Composite body,
			final Composite headerComposite, final ISessionContext context,
			final WidgetSupport support) {

		final Label header = new Label(headerComposite, support, 0);
		header.getWidget().addMouseListener(new MouseAdapter() {

			@Override
			public void mouseUp(MouseEvent e) {

				final Display display = Display.getCurrent();
				assert (display != null);

				context.getSession().asyncRequest(new ReadRequest() {

					@Override
					public void run(ReadGraph graph) throws DatabaseException {

						Object input = support.getInput();
						if (input != WidgetSupport.NO_INPUT && input != null
								&& input instanceof ISelection) {

							final Variable inputVariable = ISelectionUtils
									.filterSingleSelection((ISelection) input,
											Variable.class);
							final Variable nameVariable = inputVariable
									.getPossibleProperty(graph, Variables.NAME);
							final String initial = nameVariable.getValue(graph,
									Bindings.STRING);
							
							//final InputValidator validator = nameVariable.getInterface(graph, InputValidator.class);
							
							Layer0 L0 = Layer0.getInstance(graph);
							final Resource inputResource = inputVariable.getRepresents(graph);
							if(inputResource == null) return;
							final Resource nameResource = graph.getPossibleObject(inputResource, L0.HasName);
							if(nameResource == null) return;
							final Resource validatorResource = graph.syncRequest(new PossibleProperty(nameResource, "HasInputValidator"));
							if(validatorResource == null) return;

							
							final InputValidatorFactory validatorFactory = graph.adapt(validatorResource, InputValidatorFactory.class); 
							final InputValidator validator = validatorFactory.create(graph, nameVariable); 
							
							if (initial != null && validator != null) {

								if (display.isDisposed())
									return;

								display.asyncExec(new Runnable() {

									@Override
									public void run() {

										GridDataFactory.fillDefaults()
										.grab(true, false).span(1, 1)
										.align(SWT.CENTER, SWT.CENTER)
										.applyTo(header.getWidget());
										
										header.getWidget().setVisible(false);

										final Composite editor = new Composite(headerComposite, SWT.NONE);
										editor.setLayout(GridLayoutFactory.fillDefaults()
												.margins(0, 0).spacing(0, 0).create());
										editor.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));


										final TrackedText name = new TrackedText(
												editor, support,
												SWT.NONE);
										name.setText(initial);
										name.setInputValidator(InputValidators
												.string(validator));
										name.setFont(font);
										name.addModifyListener(new VariableStringPropertyTextModifier(
												"HasName"));
										name.addModifyListener(new TextModifyListener() {

											@Override
											public void modifyText(
													TrackedModifyEvent e) {

												editor.dispose();
												header.getWidget().setVisible(
														true);
												GridDataFactory
														.fillDefaults()
														.grab(true, false)
														.span(2, 1)
														.align(SWT.CENTER,
																SWT.CENTER)
														.applyTo(
																header.getWidget());

											}
										});
										GridDataFactory.fillDefaults()
										.grab(true, false).span(1, 1)
										.align(SWT.FILL, SWT.FILL)
										.applyTo(name.getWidget());										

										name.getWidget().forceFocus();
										name.startEdit(true);
										editor.moveAbove(null);
										
										final Label label = new Label(editor, support, SWT.NONE);
										label.setFont(smallFont2);
										label.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
										label.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_DARK_RED));
										GridDataFactory.fillDefaults()
										.grab(true, false).span(1, 1)
										.align(SWT.FILL, SWT.FILL)
										.applyTo(label.getWidget());										

										name.addValidationListener(new Consumer<String>() {

											@Override
											public void accept(String error) {
												if(error != null) label.setText(error);
												else label.setText("");
											}
											
										});
										
										GridDataFactory.fillDefaults()
												.grab(true, false).span(1, 1)
												.align(SWT.FILL, SWT.FILL)
												.applyTo(editor);
										body.layout(true);
										headerComposite.layout(true);

										support.update(name);

									}

								});

							}

						}

					}

				});

			}

		});

		header.setFont(font);
		header.setBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_WHITE));
		GridDataFactory.fillDefaults().grab(true, false).span(2, 1)
				.align(SWT.CENTER, SWT.CENTER).applyTo(header.getWidget());

		return header;

	}

	protected Label createResourceHeaderLabel(final Composite body,
			final Composite headerComposite, final ISessionContext context,
			final WidgetSupport support) {

		final Label header = new Label(headerComposite, support, 0);
		header.getWidget().addMouseListener(new MouseAdapter() {

			@Override
			public void mouseUp(MouseEvent e) {

				final Display display = Display.getCurrent();
				assert (display != null);

				context.getSession().asyncRequest(new ReadRequest() {

					@Override
					public void run(ReadGraph graph) throws DatabaseException {

						Object input = support.getInput();
						if (input != WidgetSupport.NO_INPUT && input != null
								&& input instanceof ISelection) {

							Layer0 L0 = Layer0.getInstance(graph);

							final Resource streamClass = ISelectionUtils
									.filterSingleSelection((ISelection) input,
											Resource.class);
							// final Variable inputVariable =
							// ISelectionUtils.filterSingleSelection((ISelection)input,
							// Variable.class);
							// final Variable nameVariable =
							// inputVariable.getPossibleProperty(graph,
							// Variables.NAME);
							final String initial = graph.getRelatedValue(
									streamClass, L0.HasName, Bindings.STRING);
							// final InputValidator validator =
							// nameVariable.getInterface(graph,
							// InputValidator.class);
							if (initial != null) {

								if (display.isDisposed())
									return;

								display.asyncExec(new Runnable() {

									@Override
									public void run() {

										GridDataFactory.fillDefaults()
												.grab(true, false).span(1, 1)
												.align(SWT.CENTER, SWT.CENTER)
												.applyTo(header.getWidget());
										header.getWidget().setVisible(false);

										// header.getWidget().setVisible(false);
										// header.getWidget().setText("");
										// GridDataFactory.fillDefaults().grab(false,
										// false).span(1, 1).align(SWT.CENTER,
										// SWT.CENTER).applyTo(header.getWidget());

										final TrackedText name = new TrackedText(
												headerComposite, support,
												SWT.NONE);
										name.setText(initial);
										name.setFont(font);
										name.addModifyListener(new StringPropertyModifier(
												context, Layer0.URIs.HasName));
										name.addModifyListener(new TextModifyListener() {

											@Override
											public void modifyText(
													TrackedModifyEvent e) {

												name.getWidget().dispose();
												header.getWidget().setVisible(
														true);
												GridDataFactory
														.fillDefaults()
														.grab(true, false)
														.span(2, 1)
														.align(SWT.CENTER,
																SWT.CENTER)
														.applyTo(
																header.getWidget());

												// createResourceHeaderLabel(body,
												// headerComposite, context,
												// support);

												body.layout(true);
												headerComposite.layout(true);

											}
										});

										name.getWidget().forceFocus();
										name.startEdit(true);
										name.getWidget().moveAbove(null);

										GridDataFactory.fillDefaults()
												.grab(true, false).span(1, 1)
												.align(SWT.FILL, SWT.FILL)
												.applyTo(name.getWidget());
										body.layout(true);
										headerComposite.layout(true);

										support.update(name);

									}

								});

							}

						}

					}

				});

			}

		});

		header.setFont(font);
		header.setBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_WHITE));
		GridDataFactory.fillDefaults().grab(true, false).span(2, 1)
				.align(SWT.CENTER, SWT.CENTER).applyTo(header.getWidget());

		return header;

	}

	protected Composite createHeaderComposite(Composite body) {
		return createHeaderComposite(body, 2);

	}

	protected Composite createHeaderComposite(Composite body, int width) {

		Composite headerComposite = new Composite(body, 0);
		headerComposite.setBackground(body.getDisplay().getSystemColor(
				SWT.COLOR_BLACK));
		GridDataFactory.fillDefaults().span(2, 1).grab(true, false)
				.applyTo(headerComposite);
		GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1)
				.extendedMargins(2, 2, 2, 2).applyTo(headerComposite);

		Composite headerComposite2 = new Composite(headerComposite, 0);
		headerComposite2.setBackground(body.getDisplay().getSystemColor(
				SWT.COLOR_WHITE));
		GridDataFactory.fillDefaults().span(1, 1).grab(true, false)
				.applyTo(headerComposite2);
		GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(width)
				.extendedMargins(3, 3, 3, 3).applyTo(headerComposite2);

		return headerComposite2;

	}

	protected void create(Composite body, IWorkbenchSite site,
			final ISessionContext context, WidgetSupport support) {

	}

	final public void createControls(Composite body, IWorkbenchSite site,
			final ISessionContext context, WidgetSupport support) {

		resourceManager = new LocalResourceManager(JFaceResources.getResources(), body);
		toolkit = new FormToolkit(body.getDisplay());

		body.addListener(SWT.Dispose, new Listener() {
			@Override
			public void handleEvent(Event event) {
				toolkit.dispose();
			}
		});

		font = (Font) resourceManager.get(FontDescriptor.createFrom("Arial", 14, SWT.NONE));
		smallFont = (Font) resourceManager.get(FontDescriptor.createFrom("Arial", 10, SWT.NONE));
		smallFont2 = (Font) resourceManager.get(FontDescriptor.createFrom("Arial", 8, SWT.NONE));

		create(body, site, context, support);

	}

	@Override
	public int hashCode() {
		return getClass().hashCode();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object)
			return true;
		else if (object == null)
			return false;
		return getClass().equals(object.getClass());
	}

	@Override
	public String getPartName(ISelection forSelection) {
		return "Selection";
	}

}
