/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import java.util.function.Consumer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.Column.Align;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorData.Evaluator;
import org.simantics.browsing.ui.common.comparators.AlphanumericComparatorFactory;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.graph.impl.ArrayPropertyLabelerFactory;
import org.simantics.browsing.ui.graph.impl.ArrayPropertyValueViewpointFactory;
import org.simantics.browsing.ui.graph.impl.PropertyViewpointFactory;
import org.simantics.browsing.ui.graph.impl.RelationContextLabelerFactory;
import org.simantics.browsing.ui.graph.impl.ResourceProperty;
import org.simantics.browsing.ui.graph.impl.StringRepresentationLabelerFactory;
import org.simantics.browsing.ui.swt.ArrayPropertyImagerFactory;
import org.simantics.browsing.ui.swt.PropertyIsExpandedProcessor;
import org.simantics.browsing.ui.swt.PropertyLabelDecoratorFactory;
import org.simantics.browsing.ui.swt.RootFilterArea;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public class BasicPropertyTab extends PropertyTabContributorImpl {

    protected RootFilterArea         filterArea;
    protected GraphExplorerComposite parameterExplorer;

    public void updatePartName(ISelection forSelection, Consumer<String> updateCallback) {
        updateCallback.accept(null);
    }

    protected void initializeExplorerWithEvaluator(GraphExplorer explorer, ISessionContext context,
            EvaluatorData data) {

        Evaluator resourceEvaluator = data.newEvaluator()
                .addViewpoint(new PropertyViewpointFactory(), 1.0)
                .addComparator(new AlphanumericComparatorFactory(ColumnKeys.PROPERTY), 2.0)
                .addComparator(new AlphanumericComparatorFactory(ColumnKeys.PROPERTY, true), 1.0)
                .addLabeler(new StringRepresentationLabelerFactory(ColumnKeys.PROPERTY), 1.0);

        Evaluator statementEvaluator = data.newEvaluator()
                .addViewpoint(new PropertyViewpointFactory(), 1.0)
                .addComparator(new AlphanumericComparatorFactory(ColumnKeys.PROPERTY), 2.0)
                .addComparator(new AlphanumericComparatorFactory(ColumnKeys.PROPERTY, true), 1.0);

        Evaluator relationContextEvaluator = data.newEvaluator()
                .addLabeler(new RelationContextLabelerFactory(), 1.0);

        Evaluator propertyEvaluator = data.newEvaluator()
                .addViewpoint(new ArrayPropertyValueViewpointFactory(), 1.0)
                .addLabeler(new ArrayPropertyLabelerFactory(), 1.0)
                .addImager(new ArrayPropertyImagerFactory(), 1.0)
                .addLabelDecorator(new PropertyLabelDecoratorFactory(), 1.0);

        data.addEvaluator(Resource.class, resourceEvaluator);
        data.addEvaluator(ResourceArray.class, resourceEvaluator);
        data.addEvaluator(Statement.class, statementEvaluator);
        data.addEvaluator(RelationContext.class, relationContextEvaluator);
        data.addEvaluator(ResourceProperty.class, propertyEvaluator);
    	
    }

    @Override
    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Column[] COLUMNS = new Column[] {
                new Column(ColumnKeys.PROPERTY, Align.LEFT, 175, "Property Name", true, 1),
                new Column(ColumnKeys.VALUE, Align.LEFT, 175, "Value of Property", true, 3)
        };

        parameterExplorer = new GraphExplorerComposite(
                ArrayMap.keys("displaySelectors", "displayFilter").values(false, false),
                site, body, support, SWT.FULL_SELECTION | SWT.MULTI) {
            @Override
            protected void initializeExplorerWithEvaluator(GraphExplorer explorer, ISessionContext context, EvaluatorData data) {
            	BasicPropertyTab.this.initializeExplorerWithEvaluator(explorer, context, data);
            }
        };
        // Must set, even if empty.
        parameterExplorer.setBrowseContexts();
        //parameterExplorer.setStatePersistor(new IdentifiedStatePersistor(getClass().getCanonicalName()));
        parameterExplorer.setContextMenuId("#PropertiesPopup");
        parameterExplorer.setEditingColumn(ColumnKeys.VALUE);
        parameterExplorer.setColumns(COLUMNS);
        parameterExplorer.setInputSource(new SingleSelectionInputSource(Resource.class));
        parameterExplorer.finish();
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(parameterExplorer);

        Control c = parameterExplorer.getExplorerControl();
        if (c instanceof Tree)
            ((Tree) c).setLinesVisible(true);

        FilterSelectionRequestQueryProcessor filterProcessor = new FilterSelectionRequestQueryProcessor();
        parameterExplorer.getExplorer().setPrimitiveProcessor(filterProcessor);
        filterArea = new RootFilterArea(parameterExplorer.getExplorer(), filterProcessor, parameterExplorer, SWT.NONE);
        filterArea.moveAbove(parameterExplorer.getExplorerComposite());

        // IMPORTANT: without this property expandedness tracking will not work properly
        parameterExplorer.getExplorer().setPrimitiveProcessor(new PropertyIsExpandedProcessor());
    }

    @Override
    public IFilterArea getFilterArea() {
        return filterArea;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return (ISelectionProvider) parameterExplorer.getAdapter(ISelectionProvider.class);
    }

}