/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.chr;

import java.util.Arrays;
import org.simantics.scl.runtime.chr.CHRContext;
import org.simantics.scl.runtime.chr.CHRFact;
import org.simantics.scl.runtime.chr.CHRPriority;

public abstract class CHRPriorityFactContainer
extends CHRPriority {
    private static final boolean CLEANUP_ENABLED = true;
    private static final int INITIAL_FACT_ARRAY_SIZE = 4;
    private CHRFact[] facts = new CHRFact[4];
    private int size;

    public CHRPriorityFactContainer(int priority) {
        super(priority);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void addFact(CHRContext context, CHRFact item) {
        this.ensureInContext(context);
        if (this.size == this.facts.length) {
            this.increaseCapacity();
        }
        this.facts[this.size++] = item;
    }

    private void increaseCapacity() {
        int j = 0;
        int i = 0;
        while (i < this.size) {
            CHRFact fact = this.facts[i];
            if (fact.id >= 0) {
                this.facts[j++] = fact;
            }
            ++i;
        }
        this.size = j;
        if (this.size >= this.facts.length * 3 / 4) {
            this.facts = Arrays.copyOf(this.facts, this.size * 2);
        }
    }

    @Override
    public void activate(CHRContext context) {
        while (this.size > 0) {
            --this.size;
            CHRFact fact = this.facts[this.size];
            this.facts[this.size] = null;
            if (fact.id < 0) continue;
            this.activate(context, fact);
        }
    }

    protected abstract void activate(CHRContext var1, CHRFact var2);
}

