/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidatorFactory;
import org.simantics.scl.compiler.internal.codegen.types.RuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.osgi.internal.BundleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiJavaReferenceValidatorFactory
implements JavaReferenceValidatorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsgiJavaReferenceValidatorFactory.class);
    private final Bundle bundle;

    public OsgiJavaReferenceValidatorFactory(Bundle bundle) {
        this.bundle = bundle;
    }

    private static ClassLoader getClassLoader(Bundle bundle) {
        if (bundle.getSymbolicName().equals("org.simantics.scl.runtime")) {
            return Type.class.getClassLoader();
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null && bundle.getState() == 2) {
            LOGGER.info("Starting bundle {} with state {}", (Object)bundle.getSymbolicName(), (Object)BundleUtils.resolveBundleState(bundle));
            try {
                bundle.start();
            }
            catch (BundleException e) {
                throw new InternalCompilerError("Couldn't activate bundle " + bundle.getSymbolicName() + ". Bundle state is " + BundleUtils.resolveBundleState(bundle), (Throwable)e);
            }
            wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        }
        if (wiring != null) {
            return wiring.getClassLoader();
        }
        throw new InternalCompilerError("Cannot get the class loader for bundle " + bundle.getSymbolicName() + ". Bundle state is " + BundleUtils.resolveBundleState(bundle));
    }

    private static JavaReferenceValidator<Object, Object, Object, Object> getJavaReferenceValidator(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return new RuntimeJavaReferenceValidator(OsgiJavaReferenceValidatorFactory.getClassLoader(bundle));
    }

    private static Bundle getBundle(BundleContext bundleContext, String symbolicName) {
        Bundle result = null;
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle candidate = bundleArray[n2];
            if (candidate.getSymbolicName().equals(symbolicName) && (result == null || result.getVersion().compareTo(candidate.getVersion()) < 0)) {
                result = candidate;
            }
            ++n2;
        }
        return result;
    }

    public JavaReferenceValidator<Object, Object, Object, Object> getJavaReferenceValidator(String bundleName) {
        LOGGER.debug("getJavaReferenceValidator(" + bundleName + ")");
        return OsgiJavaReferenceValidatorFactory.getJavaReferenceValidator(OsgiJavaReferenceValidatorFactory.getBundle(this.bundle.getBundleContext(), bundleName));
    }

    public JavaReferenceValidator<Object, Object, Object, Object> getDefaultJavaReferenceValidator() {
        return OsgiJavaReferenceValidatorFactory.getJavaReferenceValidator(this.bundle);
    }
}

