package org.simantics.scl.osgi.issues;

import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;

public abstract class SCLIssuesTableEntry implements Comparable<SCLIssuesTableEntry> {
    public final String moduleName;
    public final CompilationError error;

    public SCLIssuesTableEntry(String moduleName, CompilationError error) {
        this.moduleName = moduleName;
        this.error = error;
    }

    public abstract void openLocation();

    @Override
    public int compareTo(SCLIssuesTableEntry o) {
        if(this == o)
            return 0;
        int cmp = error.severity.compareTo(o.error.severity);
        if(cmp != 0)
            return cmp;
        cmp = moduleName.compareTo(o.moduleName);
        if(cmp != 0)
            return cmp;
        cmp = Locations.compare(error.location, o.error.location);
        if(cmp != 0)
            return cmp;
        return error.description.compareTo(o.error.description);
    }
}
