package org.simantics.scl.osgi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.java.SafeExternalConstant;
import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.compiler.testing.repository.TestRepository;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.internal.ServiceBasedModuleSourceRepository;
import org.simantics.scl.osgi.internal.ServiceBasedTestRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gnu.trove.procedure.TObjectProcedure;


public class SCLOsgi {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLOsgi.class);

    private SCLOsgi() {}
    
    public static class SCLOsgiModuleRepository extends ModuleRepository implements SafeExternalConstant, Externalizable {

		public SCLOsgiModuleRepository() {
			super(null);
		}

    	public SCLOsgiModuleRepository(ModuleSourceRepository sourceRepository) {
			super(sourceRepository);
		}

	    protected Object readResolve() {
	    	return MODULE_REPOSITORY;
	    }

		@Override
		public void writeExternal(ObjectOutput out) throws IOException {
			// Nothing to write
		}

		@Override
		public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
			// Nothing to read
		}    

    }
    
    public static ModuleSourceRepository SOURCE_REPOSITORY = new ServiceBasedModuleSourceRepository(Activator.getContext());
    public static ModuleRepository MODULE_REPOSITORY = new SCLOsgiModuleRepository(SOURCE_REPOSITORY);
    public static TestRepository TEST_REPOSITORY = new ServiceBasedTestRepository(Activator.getContext());

    public static String compileAllModules() {
        ArrayList<String> modulesWithErrors = new ArrayList<String>(); 
        SCLOsgi.SOURCE_REPOSITORY.forAllModules(new TObjectProcedure<String>() {
            @Override
            public boolean execute(String moduleName) {
                Failable<Module> module = SCLOsgi.MODULE_REPOSITORY.getModule(moduleName);
                if(module.didSucceed())
                    LOGGER.trace("{} - {}", moduleName, "succeeded");
                else if(module == DoesNotExist.INSTANCE)
                    LOGGER.trace("{} - {}", moduleName, "does not exist"); // should not happen
                else {
                    LOGGER.trace("{} - {}", moduleName, "error");
                    modulesWithErrors.add(moduleName);
                }
                return true;
            }
        });
        if(!modulesWithErrors.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Some SCL modules failed to compile:");
            for(String module : modulesWithErrors)
                b.append(' ').append(module);
            return b.toString();
        }
        return null;
    }
}
