/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TApplyAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class TPred
extends Type {
    public static final TPred[] EMPTY_ARRAY = new TPred[0];
    public final TCon typeClass;
    public final Type[] parameters;

    TPred(TCon typeClass, Type ... parameters) {
        if (typeClass == null || parameters == null) {
            throw new NullPointerException();
        }
        Type[] typeArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (parameter == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        this.typeClass = typeClass;
        this.parameters = parameters;
    }

    @Override
    public TPred replace(TVar var, Type replacement) {
        int i = 0;
        while (i < this.parameters.length) {
            Type parameter = this.parameters[i];
            Type newParameter = parameter.replace(var, replacement);
            if (parameter != newParameter) {
                Type[] newParameters = new Type[this.parameters.length];
                int j = 0;
                while (j < i) {
                    newParameters[j] = this.parameters[j];
                    ++j;
                }
                newParameters[i] = newParameter;
                j = i + 1;
                while (j < this.parameters.length) {
                    newParameters[j] = this.parameters[j].replace(var, replacement);
                    ++j;
                }
                return new TPred(this.typeClass, newParameters);
            }
            ++i;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        TypeAst ast = this.typeClass.toTypeAst(context);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            ast = new TApplyAst(ast, parameter.toTypeAst(context));
            ++n2;
        }
        return ast;
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        this.typeClass.updateHashCode(context);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.updateHashCode(context);
            ++n2;
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectFreeVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public boolean contains(TMetaVar other) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (parameter.contains(other)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Type convertMetaVarsToVars() {
        int i = 0;
        while (i < this.parameters.length) {
            Type parameter = this.parameters[i];
            Type temp = parameter.convertMetaVarsToVars();
            if (temp != parameter) {
                Type[] newParameters = new Type[this.parameters.length];
                int j = 0;
                while (j < i) {
                    newParameters[j] = this.parameters[j];
                    ++j;
                }
                newParameters[i] = temp;
                j = i + 1;
                while (j < this.parameters.length) {
                    newParameters[j] = this.parameters[j].convertMetaVarsToVars();
                    ++j;
                }
                return new TPred(this.typeClass, this.parameters);
            }
            ++i;
        }
        return this;
    }

    @Override
    public boolean isGround() {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (!parameter.isGround()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Kind inferKind(Environment context) throws KindUnificationException {
        return Kinds.STAR;
    }

    @Override
    public boolean containsMetaVars() {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (parameter.containsMetaVars()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.typeClass.toName(context, b);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            b.append('_');
            parameter.toName(context, b);
            ++n2;
        }
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.addPolarity(Polarity.BIPOLAR);
            ++n2;
        }
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectEffectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public Type head() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        Type[] newParameters = new Type[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            newParameters[i] = this.parameters[i].copySkeleton(metaVarMap);
            ++i;
        }
        return new TPred(this.typeClass, this.parameters);
    }

    @Override
    public int hashCode(int hash) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, PRED_HASH);
        hash = this.typeClass.hashCode(hash);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            hash = parameter.hashCode(hash);
            ++n2;
        }
        return hash;
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, PRED_HASH);
        hash = this.typeClass.hashCode(hash, boundVars);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            hash = parameter.hashCode(hash, boundVars);
            ++n2;
        }
        return hash;
    }

    @Override
    public int skeletonHashCode(int hash) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, PRED_HASH);
        hash = this.typeClass.skeletonHashCode(hash);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            hash = parameter.skeletonHashCode(hash);
            ++n2;
        }
        return hash;
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        hash = HashCodeUtils.updateWithPreprocessedValue(hash, PRED_HASH);
        hash = this.typeClass.skeletonHashCode(hash, boundVars);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            hash = parameter.skeletonHashCode(hash, boundVars);
            ++n2;
        }
        return hash;
    }

    @Override
    public boolean equalsCanonical(Type other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(TPred.class)) {
            return false;
        }
        TPred pred = (TPred)other;
        if (this.typeClass != pred.typeClass || this.parameters.length != pred.parameters.length) {
            return false;
        }
        int i = 0;
        while (i < this.parameters.length) {
            if (!Types.canonical(this.parameters[i]).equalsCanonical(Types.canonical(pred.parameters[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Kind getKind(Environment context) {
        return Kinds.STAR;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        Type[] result = new Type[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            result[i] = Skeletons.canonicalSkeleton(this.parameters[i]);
            ++i;
        }
        return result;
    }
}

