/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.regexp;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.scl.compiler.parser.regexp.Namer;
import org.simantics.scl.compiler.parser.regexp.RAtom;
import org.simantics.scl.compiler.parser.regexp.ROp;
import org.simantics.scl.compiler.parser.regexp.ROr;
import org.simantics.scl.compiler.parser.regexp.RSeq;
import org.simantics.scl.compiler.parser.regexp.automata.NFA;

public abstract class Regexp
implements Comparable<Regexp> {
    static final int ATOM = 0;
    static final int OP = 1;
    static final int OR = 2;
    static final int SEQ = 3;
    public static final Regexp ONE = new RSeq(new Regexp[0]);
    public static final Regexp ZERO = new ROr(new Regexp[0]);

    protected abstract void buildAutomaton(NFA var1, int var2, int var3);

    Regexp() {
    }

    public NFA toAutomaton() {
        NFA aut = new NFA();
        int inState = aut.newState();
        int outState = aut.newState();
        this.buildAutomaton(aut, inState, outState);
        aut.setInitialState(inState);
        aut.setAccepts(outState, true);
        return aut;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b, 0);
        return b.toString();
    }

    protected abstract void toString(StringBuilder var1, int var2);

    protected abstract int getTypeId();

    public abstract boolean isNullable();

    public Regexp simplify() {
        return this;
    }

    private static int parseRegexp(int pos, String regexp, AtomicReference<Regexp> result) {
        ArrayList<Regexp> dc = new ArrayList<Regexp>();
        ArrayList<Regexp> cc = new ArrayList<Regexp>();
        block8: while (pos != regexp.length()) {
            char c = regexp.charAt(pos++);
            switch (c) {
                case '(': {
                    AtomicReference<Regexp> child = new AtomicReference<Regexp>();
                    pos = Regexp.parseRegexp(pos, regexp, child);
                    cc.add(child.get());
                    continue block8;
                }
                case ')': {
                    break block8;
                }
                case '|': {
                    dc.add(Regexp.seq(cc));
                    cc.clear();
                    continue block8;
                }
                case '*': {
                    if (cc.isEmpty()) {
                        throw new IllegalArgumentException("Encountered * that is not front of anything.");
                    }
                    int p = cc.size() - 1;
                    cc.set(p, Regexp.star(cc.get(p)));
                    continue block8;
                }
                case '?': {
                    if (cc.isEmpty()) {
                        throw new IllegalArgumentException("Encountered ? that is not front of anything.");
                    }
                    int p = cc.size() - 1;
                    cc.set(p, Regexp.optional(cc.get(p)));
                    continue block8;
                }
                case '+': {
                    if (cc.isEmpty()) {
                        throw new IllegalArgumentException("Encountered + that is not front of anything.");
                    }
                    int p = cc.size() - 1;
                    cc.set(p, Regexp.plus(cc.get(p)));
                    continue block8;
                }
                default: {
                    cc.add(new RAtom(c));
                    continue block8;
                }
            }
        }
        dc.add(Regexp.seq(cc));
        result.set(Regexp.or(dc));
        return pos;
    }

    public static Regexp of(String regexp) {
        AtomicReference<Regexp> result = new AtomicReference<Regexp>();
        int finalPos = Regexp.parseRegexp(0, regexp, result);
        if (finalPos < regexp.length()) {
            throw new IllegalArgumentException("Extra closing parenteses");
        }
        return result.get();
    }

    static void seq(ArrayList<Regexp> l, Regexp exp) {
        if (l.size() > 0 && l.get(0) == ZERO) {
            return;
        }
        if (exp instanceof RSeq) {
            Regexp[] regexpArray = ((RSeq)exp).exps;
            int n = ((RSeq)exp).exps.length;
            int n2 = 0;
            while (n2 < n) {
                Regexp e = regexpArray[n2];
                Regexp.seq(l, e);
                ++n2;
            }
        } else if (exp == ZERO) {
            l.clear();
            l.add(exp);
        } else {
            l.add(exp);
        }
    }

    static Regexp seq_(List<Regexp> es) {
        if (es.size() == 0) {
            return ONE;
        }
        if (es.size() == 1) {
            return es.get(0);
        }
        Regexp[] eArray = es.toArray(new Regexp[es.size()]);
        return new RSeq(eArray);
    }

    public static Regexp seq(Regexp ... exps) {
        if (exps.length == 0) {
            return ONE;
        }
        if (exps.length == 1) {
            return exps[0];
        }
        ArrayList<Regexp> es = new ArrayList<Regexp>();
        Regexp[] regexpArray = exps;
        int n = exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            Regexp.seq(es, exp);
            ++n2;
        }
        return Regexp.seq_(es);
    }

    public static Regexp seq(Collection<Regexp> exps) {
        return Regexp.seq(exps.toArray(new Regexp[exps.size()]));
    }

    static void or(THashSet<Regexp> s, Regexp exp) {
        if (exp instanceof ROr) {
            Regexp[] regexpArray = ((ROr)exp).exps;
            int n = ((ROr)exp).exps.length;
            int n2 = 0;
            while (n2 < n) {
                Regexp e = regexpArray[n2];
                Regexp.or(s, e);
                ++n2;
            }
        } else {
            s.add((Object)exp);
        }
    }

    static Regexp or_(THashSet<Regexp> es) {
        if (es.size() == 0) {
            return ZERO;
        }
        if (es.size() == 1) {
            return (Regexp)es.iterator().next();
        }
        Object[] eArray = (Regexp[])es.toArray((Object[])new Regexp[es.size()]);
        Arrays.sort(eArray);
        return new ROr((Regexp[])eArray);
    }

    public static Regexp or(Regexp ... exps) {
        if (exps.length == 0) {
            return ZERO;
        }
        if (exps.length == 1) {
            return exps[0];
        }
        THashSet es = new THashSet();
        Regexp[] regexpArray = exps;
        int n = exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            Regexp.or((THashSet<Regexp>)es, exp);
            ++n2;
        }
        return Regexp.or_((THashSet<Regexp>)es);
    }

    public static Regexp star(Regexp exp) {
        if (exp == ONE || exp == ZERO) {
            return ONE;
        }
        return new ROp(exp, '*');
    }

    public static Regexp plus(Regexp exp) {
        return new ROp(exp, '+');
    }

    public static Regexp optional(Regexp exp) {
        return new ROp(exp, '?');
    }

    public static Regexp or(Collection<Regexp> exps) {
        return Regexp.or(exps.toArray(new Regexp[exps.size()]));
    }

    @Override
    public int compareTo(Regexp o) {
        int tB;
        int tA = this.getTypeId();
        if (tA < (tB = o.getTypeId())) {
            return -1;
        }
        if (tA > tB) {
            return 1;
        }
        switch (tA) {
            case 0: {
                int sA = ((RAtom)this).symbolId;
                int sB = ((RAtom)o).symbolId;
                if (sA < sB) {
                    return -1;
                }
                if (sA > sB) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                ROp a = (ROp)this;
                ROp b = (ROp)o;
                if (a.op < b.op) {
                    return -1;
                }
                if (a.op > b.op) {
                    return 1;
                }
                return a.exp.compareTo(b.exp);
            }
            case 2: {
                return Regexp.compare(((ROr)this).exps, ((ROr)o).exps);
            }
            case 3: {
                return Regexp.compare(((RSeq)this).exps, ((RSeq)o).exps);
            }
        }
        throw new IllegalArgumentException();
    }

    private static int compare(Regexp[] a, Regexp[] b) {
        if (a.length < b.length) {
            return -1;
        }
        if (a.length > b.length) {
            return 1;
        }
        int i = 0;
        while (i < a.length) {
            int temp = a[i].compareTo(b[i]);
            if (temp != 0) {
                return temp;
            }
            ++i;
        }
        return 0;
    }

    public abstract void toString(StringBuilder var1, Namer var2, int var3);
}

