/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.compression;

public class GraphColoring {
    public static int color(int[] color, ColGraph graph) {
        int size = graph.size();
        int[] unassigned = new int[size];
        int i = 0;
        while (i < size) {
            unassigned[i] = i;
            ++i;
        }
        int unassignedCount = size;
        int[] blockedCount = new int[size];
        boolean[][] blocked = new boolean[size][size];
        int colorCount = 0;
        while (unassignedCount > 0) {
            int bestId = 0;
            int bestUnassignedTableId = 0;
            int bestBlockedCount = -1;
            int i2 = 0;
            while (i2 < unassignedCount) {
                int id = unassigned[i2];
                int tempCount = blockedCount[id];
                if (tempCount > bestBlockedCount) {
                    bestUnassignedTableId = i2;
                    bestId = id;
                    bestBlockedCount = tempCount;
                }
                ++i2;
            }
            unassigned[bestUnassignedTableId] = unassigned[--unassignedCount];
            int chosenColor = 0;
            if (bestBlockedCount == colorCount) {
                chosenColor = colorCount++;
            } else {
                int i3 = 0;
                while (i3 < colorCount) {
                    if (!blocked[i3][bestId]) {
                        chosenColor = i3;
                        break;
                    }
                    ++i3;
                }
            }
            color[bestId] = chosenColor;
            boolean[] blockedRow = blocked[chosenColor];
            int i4 = 0;
            while (i4 < unassignedCount) {
                int id = unassigned[i4];
                if (!blockedRow[id] && graph.areConnected(bestId, id)) {
                    blockedRow[id] = true;
                    int n = id;
                    blockedCount[n] = blockedCount[n] + 1;
                }
                ++i4;
            }
        }
        return colorCount;
    }

    public static interface ColGraph {
        public int size();

        public boolean areConnected(int var1, int var2);
    }
}

