/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.inlines;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.markdown.inlines.Delimiter;
import org.simantics.scl.compiler.markdown.inlines.Entities;
import org.simantics.scl.compiler.markdown.internal.Scanner;
import org.simantics.scl.compiler.markdown.nodes.AutolinkNode;
import org.simantics.scl.compiler.markdown.nodes.CodeNode;
import org.simantics.scl.compiler.markdown.nodes.EmphNode;
import org.simantics.scl.compiler.markdown.nodes.HardLineBreakNode;
import org.simantics.scl.compiler.markdown.nodes.HtmlTagNode;
import org.simantics.scl.compiler.markdown.nodes.ImageNode;
import org.simantics.scl.compiler.markdown.nodes.LinkNode;
import org.simantics.scl.compiler.markdown.nodes.Node;
import org.simantics.scl.compiler.markdown.nodes.Reference;
import org.simantics.scl.compiler.markdown.nodes.TextNode;

public class Subject {
    THashMap<String, Reference> referenceMap;
    StringBuilder input;
    int pos;
    Delimiter lastDelim;
    public static final int CHAR_TYPE_WHITESPACE = 1;
    public static final int CHAR_TYPE_PUNCTUATION = 2;
    public static final int CHAR_TYPE_OTHER = 0;
    static final boolean[] SPECIAL_CHARS = new boolean[128];
    static final String SPECIALS_STRING = "\n\\`&_*[]<!";

    static {
        int i = 0;
        while (i < SPECIALS_STRING.length()) {
            Subject.SPECIAL_CHARS[SPECIALS_STRING.charAt((int)i)] = true;
            ++i;
        }
    }

    public Subject(THashMap<String, Reference> referenceMap, StringBuilder input) {
        this.referenceMap = referenceMap;
        this.input = input;
        this.pos = 0;
    }

    public static void parseInlines(THashMap<String, Reference> referenceMap, Node parent) {
        Subject subject = new Subject(referenceMap, parent.stringContent);
        while (!subject.isEof() && subject.parseInline(parent)) {
        }
        subject.processEmphasis(null);
        parent.stringContent = null;
    }

    private void processEmphasis(Delimiter begin) {
        if (this.lastDelim == begin) {
            return;
        }
        Delimiter closer = this.lastDelim;
        while (closer.previous != begin) {
            closer = closer.previous;
        }
        closer = closer.next;
        while (closer != null) {
            if (closer.canClose) {
                Delimiter opener = closer.previous;
                while (opener != begin) {
                    if (opener.canOpen && opener.delimChar == closer.delimChar) {
                        closer = this.insertEmph(opener, closer);
                        break;
                    }
                    opener = opener.previous;
                }
            }
            closer = closer.next;
        }
    }

    private Delimiter insertEmph(Delimiter opener, Delimiter closer) {
        int closerLength;
        opener.next = closer;
        closer.previous = opener;
        int openerLength = opener.inlText.stringContent.length();
        int commonLength = Math.min(openerLength, closerLength = closer.inlText.stringContent.length());
        if (commonLength > 2) {
            commonLength = 2 - closerLength % 2;
        }
        EmphNode emph = new EmphNode(commonLength == 2);
        emph.firstChild = opener.inlText.next;
        emph.lastChild = closer.inlText.prev;
        emph.firstChild.prev = null;
        emph.lastChild.next = null;
        opener.inlText.next = emph;
        closer.inlText.prev = emph;
        emph.next = closer.inlText;
        emph.prev = opener.inlText;
        emph.parent = opener.inlText.parent;
        Node node = emph.firstChild;
        while (node != null) {
            node.parent = emph;
            node = node.next;
        }
        if (openerLength == commonLength) {
            this.removeDelim(opener);
            opener.inlText.remove();
        } else {
            opener.inlText.stringContent.delete(openerLength - commonLength, openerLength);
        }
        if (closerLength == commonLength) {
            this.removeDelim(closer);
            closer.inlText.remove();
            return closer;
        }
        closer.inlText.stringContent.delete(closerLength - commonLength, closerLength);
        if (closer.previous != null) {
            return closer.previous;
        }
        return closer;
    }

    private boolean parseInline(Node parent) {
        Node newInl = null;
        char c = this.peekChar();
        if (c == '\u0000') {
            return false;
        }
        switch (c) {
            case '\\': {
                newInl = this.handleBackslash();
                break;
            }
            case '`': {
                newInl = this.handleBackticks();
                break;
            }
            case '<': {
                newInl = this.handlePointyBrace();
                break;
            }
            case '\n': {
                newInl = this.handleNewline();
                break;
            }
            case '[': {
                newInl = new TextNode(new StringBuilder("["));
                this.lastDelim = new Delimiter(this.lastDelim, newInl, this.pos, '[', false, false);
                ++this.pos;
                break;
            }
            case '!': {
                ++this.pos;
                if (this.peekChar() == '[') {
                    newInl = new TextNode(new StringBuilder("!["));
                    this.lastDelim = new Delimiter(this.lastDelim, newInl, this.pos - 1, '!', false, false);
                    ++this.pos;
                    break;
                }
                newInl = new TextNode(new StringBuilder("!"));
                break;
            }
            case ']': {
                newInl = this.handleCloseBracket();
                if (newInl != null) break;
                newInl = new TextNode(new StringBuilder("]"));
                break;
            }
            case '&': {
                newInl = this.handleEntity();
                if (newInl != null) break;
                newInl = new TextNode(new StringBuilder("&"));
                break;
            }
            case '\"': 
            case '\'': 
            case '*': 
            case '_': {
                newInl = this.handleDelim(c);
                break;
            }
            default: {
                int startPos = this.pos++;
                while (this.pos < this.input.length() && !Subject.isSpecialChar(this.input.charAt(this.pos))) {
                    ++this.pos;
                }
                char nc = this.peekChar();
                int tEnd = this.pos;
                if (nc == '\n' || nc == '\u0000') {
                    while (tEnd > startPos && this.input.charAt(tEnd - 1) == ' ') {
                        --tEnd;
                    }
                }
                newInl = new TextNode(new StringBuilder(this.input.subSequence(startPos, tEnd)));
            }
        }
        if (newInl != null) {
            this.addChild(parent, newInl);
        }
        return true;
    }

    private Node handleEntity() {
        ++this.pos;
        if (this.peekChar() == '#') {
            int p = this.pos + 1;
            if (p == this.input.length()) {
                return null;
            }
            char c = this.input.charAt(p);
            if (c == 'x' || c == 'X') {
                int code = 0;
                int i = 0;
                while (i < 8) {
                    if ((c = this.input.charAt(++p)) == ';') {
                        if (p == this.pos + 2) {
                            return null;
                        }
                        this.pos = p + 1;
                        if (!Character.isValidCodePoint(code)) {
                            code = 65533;
                        }
                        return new TextNode(new StringBuilder(new String(new int[]{code}, 0, 1)));
                    }
                    if (c >= '0' && c <= '9') {
                        code *= 16;
                        code += c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        code *= 16;
                        code += c - 97 + 10;
                    } else if (c >= 'A' && c <= 'F') {
                        code *= 16;
                        code += c - 65 + 10;
                    }
                    ++i;
                }
                return null;
            }
            if (c >= '0' && c <= '9') {
                int code = c - 48;
                int i = 0;
                while (i < 8) {
                    if ((c = this.input.charAt(++p)) == ';') {
                        if (p == this.pos + 1) {
                            return null;
                        }
                        this.pos = p + 1;
                        if (!Character.isValidCodePoint(code)) {
                            code = 65533;
                        }
                        return new TextNode(new StringBuilder(new String(new int[]{code}, 0, 1)));
                    }
                    if (c >= '0' && c <= '9') {
                        code *= 10;
                        code += c - 48;
                    }
                    ++i;
                }
                return null;
            }
            return null;
        }
        int maxPos = Math.min(this.input.length(), this.pos + Entities.MAX_ENTITY_LENGTH + 1);
        int p = this.pos;
        while (p < maxPos) {
            char c;
            if ((c = this.input.charAt(p++)) != ';') continue;
            String entity = this.input.substring(this.pos, p - 1);
            String character = (String)Entities.ENTITY_MAP.get((Object)entity);
            if (character == null) {
                return null;
            }
            this.pos = p;
            return new TextNode(new StringBuilder(character));
        }
        return null;
    }

    private Node handleCloseBracket() {
        String title;
        String url;
        int urlEnd;
        int urlStart;
        ++this.pos;
        Delimiter opener = this.lastDelim;
        while (opener != null) {
            if (opener.delimChar == '[' || opener.delimChar == '!') break;
            opener = opener.previous;
        }
        if (opener == null) {
            return null;
        }
        this.remove(opener);
        if (!opener.active) {
            return null;
        }
        String label = this.input.substring(opener.position + (opener.delimChar == '[' ? 1 : 2), this.pos - 1);
        if (this.pos < this.input.length() && this.input.charAt(this.pos) == '(' && (urlStart = Scanner.scanWhitespace(this.input, this.pos + 1)) >= 0 && (urlEnd = Scanner.scanLinkUrl(this.input, urlStart)) >= 0) {
            int titleEnd;
            int titleStart = Scanner.scanWhitespace(this.input, urlEnd);
            if (titleStart == -1) {
                return null;
            }
            int n = titleEnd = titleStart == urlEnd ? titleStart : Scanner.scanLinkTitle(this.input, titleStart);
            if (titleEnd == -1) {
                return null;
            }
            int endAll = Scanner.scanWhitespace(this.input, titleEnd);
            if (endAll == -1 || this.input.charAt(endAll) != ')') {
                return null;
            }
            this.pos = endAll + 1;
            url = this.input.charAt(urlStart) == '<' ? this.input.substring(urlStart + 1, urlEnd - 1) : this.input.substring(urlStart, urlEnd);
            url = Reference.cleanUrl(url);
            title = titleStart == titleEnd ? "" : Reference.cleanTitle(this.input.substring(titleStart + 1, titleEnd - 1));
        } else {
            Reference reference;
            int linkEnd;
            int originalPos = this.pos;
            String normalizedLabel = null;
            int linkStart = Scanner.scanWhitespace(this.input, this.pos);
            if (linkStart != -1 && this.input.charAt(linkStart) == '[' && (linkEnd = Scanner.scanLinkLabel(this.input, linkStart)) != -1) {
                if (linkStart + 2 < linkEnd) {
                    normalizedLabel = Reference.normalizeLabel(this.input.substring(linkStart + 1, linkEnd - 1));
                }
                this.pos = linkEnd;
            }
            if (normalizedLabel == null) {
                normalizedLabel = Reference.normalizeLabel(label);
            }
            if ((reference = (Reference)this.referenceMap.get((Object)normalizedLabel)) == null) {
                this.pos = originalPos;
                return null;
            }
            url = reference.url;
            title = reference.title;
        }
        Node newLast = opener.inlText.prev;
        Node parent = opener.inlText.parent;
        this.processEmphasis(opener.previous);
        Node newNode = opener.delimChar == '[' ? new LinkNode(label, url, title) : new ImageNode(label, url, title);
        opener.inlText.prev = null;
        newNode.firstChild = opener.inlText;
        newNode.lastChild = parent.lastChild;
        Node node = newNode.firstChild;
        while (node != null) {
            node.parent = newNode;
            node = node.next;
        }
        opener.inlText.remove();
        parent.lastChild = newLast;
        if (newLast != null) {
            newLast.next = null;
        } else {
            parent.firstChild = null;
        }
        this.lastDelim = opener.previous;
        if (this.lastDelim != null) {
            this.lastDelim.next = null;
        }
        if (opener.delimChar == '[') {
            Delimiter cur = this.lastDelim;
            while (cur != null && cur.active) {
                if (cur.delimChar == '[') {
                    cur.active = false;
                }
                cur = cur.previous;
            }
        }
        return newNode;
    }

    private void remove(Delimiter delimiter) {
        if (delimiter.previous != null) {
            delimiter.previous.next = delimiter.next;
        }
        if (delimiter.next != null) {
            delimiter.next.previous = delimiter.previous;
        } else {
            this.lastDelim = delimiter.previous;
        }
    }

    private Node handleNewline() {
        int nlPos = this.pos++;
        while (this.peekChar() == ' ') {
            ++this.pos;
        }
        if (nlPos > 1 && this.input.charAt(nlPos - 1) == ' ' && this.input.charAt(nlPos - 2) == ' ') {
            return new HardLineBreakNode();
        }
        return new TextNode(new StringBuilder("\n"));
    }

    private Node handlePointyBrace() {
        ++this.pos;
        int p = Scanner.scanUri(this.input, this.pos);
        if (p >= 0) {
            AutolinkNode result = new AutolinkNode(new StringBuilder(this.input.substring(this.pos, p - 1)), false);
            this.pos = p;
            return result;
        }
        p = Scanner.scanEmail(this.input, this.pos);
        if (p >= 0) {
            AutolinkNode result = new AutolinkNode(new StringBuilder(this.input.substring(this.pos, p - 1)), true);
            this.pos = p;
            return result;
        }
        p = Scanner.scanHtmlTag(this.input, this.pos);
        if (p >= 0) {
            HtmlTagNode result = new HtmlTagNode(new StringBuilder(this.input.substring(this.pos - 1, p)));
            this.pos = p;
            return result;
        }
        return new TextNode(new StringBuilder("<"));
    }

    private Node handleBackslash() {
        ++this.pos;
        char c = this.peekChar();
        ++this.pos;
        if (c == '\u0000') {
            StringBuilder b = new StringBuilder(2);
            b.append('\\');
            return new TextNode(b);
        }
        if (Subject.getCharType(c) == 2) {
            StringBuilder b = new StringBuilder(1);
            b.append(c);
            return new TextNode(b);
        }
        if (c == '\n') {
            return new HardLineBreakNode();
        }
        StringBuilder b = new StringBuilder(2);
        b.append('\\');
        b.append(c);
        return new TextNode(b);
    }

    private Node handleBackticks() {
        int startPos = this.pos;
        while (this.peekChar() == '`') {
            ++this.pos;
        }
        int tickCount = this.pos - startPos;
        while (true) {
            char c;
            if ((c = this.peekChar()) != '`' && c != '\u0000') {
                ++this.pos;
                continue;
            }
            if (c == '\u0000') {
                this.pos = startPos + tickCount;
                StringBuilder b = new StringBuilder(tickCount);
                int i = 0;
                while (i < tickCount) {
                    b.append('`');
                    ++i;
                }
                return new TextNode(b);
            }
            int endTickCount = 0;
            while (this.peekChar() == '`') {
                ++this.pos;
                ++endTickCount;
            }
            if (endTickCount == tickCount) break;
        }
        return new CodeNode(this.normalizeWhitespace(startPos + tickCount, this.pos - tickCount));
    }

    private StringBuilder normalizeWhitespace(int begin, int end) {
        while (begin < end && Subject.isWhitespace(this.input.charAt(begin))) {
            ++begin;
        }
        while (begin < end && Subject.isWhitespace(this.input.charAt(end - 1))) {
            --end;
        }
        StringBuilder b = new StringBuilder(end - begin);
        boolean lastCharWasWhitespace = false;
        while (begin < end) {
            char c;
            if (Subject.isWhitespace(c = this.input.charAt(begin++))) {
                if (lastCharWasWhitespace) continue;
                lastCharWasWhitespace = true;
                b.append(' ');
                continue;
            }
            lastCharWasWhitespace = false;
            b.append(c);
        }
        return b;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n';
    }

    private Node handleDelim(char c) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int startPos = this.pos;
        char beforeChar = this.pos == 0 ? (char)'\n' : (char)this.input.charAt(this.pos - 1);
        ++this.pos;
        while (this.pos < this.input.length() && this.input.charAt(this.pos) == c) {
            ++this.pos;
        }
        char afterChar = this.pos == this.input.length() ? (char)'\n' : (char)this.input.charAt(this.pos);
        int beforeCharType = Subject.getCharType(beforeChar);
        int afterCharType = Subject.getCharType(afterChar);
        boolean leftFlanking = afterCharType != 1 && (afterCharType != 2 || beforeCharType != 0);
        boolean bl = rightFlanking = beforeCharType != 1 && (beforeCharType != 2 || afterCharType != 0);
        if (c == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeCharType == 2);
            canClose = rightFlanking && (!leftFlanking || afterCharType == 2);
        } else {
            canOpen = leftFlanking;
            canClose = rightFlanking;
        }
        TextNode inlText = new TextNode(new StringBuilder(this.input.subSequence(startPos, this.pos)));
        this.lastDelim = new Delimiter(this.lastDelim, inlText, this.pos, c, canOpen, canClose);
        return inlText;
    }

    public static int getCharType(char c) {
        switch (c) {
            case '\n': 
            case ' ': {
                return 1;
            }
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return 2;
            }
        }
        return 0;
    }

    private char peekChar() {
        if (this.pos < this.input.length()) {
            return this.input.charAt(this.pos);
        }
        return '\u0000';
    }

    private boolean isEof() {
        return this.pos >= this.input.length();
    }

    private static boolean isSpecialChar(char c) {
        return c >= '\u0000' && c < '\u0080' && SPECIAL_CHARS[c];
    }

    private void addChild(Node parent, Node child) {
        child.parent = parent;
        if (parent.lastChild == null) {
            parent.firstChild = child;
        } else {
            Node oldLast = parent.lastChild;
            oldLast.next = child;
            child.prev = oldLast;
        }
        parent.lastChild = child;
    }

    private void removeDelim(Delimiter delim) {
        Delimiter previous = delim.previous;
        Delimiter next = delim.next;
        if (delim == this.lastDelim) {
            this.lastDelim = previous;
        } else {
            next.previous = previous;
        }
        if (previous != null) {
            previous.next = next;
        }
    }
}

