/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.subsumption;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.subsumption.Subsumption;
import org.simantics.scl.compiler.internal.elaboration.subsumption.VUnion;
import org.simantics.scl.compiler.internal.elaboration.subsumption.Var;
import org.simantics.scl.compiler.internal.types.effects.EffectIdMap;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TUnion;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class SubSolver {
    public static final boolean DEBUG = false;
    long globalLoc;
    ErrorLog errorLog;
    ArrayList<Subsumption> subsumptions;
    ArrayList<Type> potentialSingletonEffects;
    EffectIdMap effectIds = new EffectIdMap();
    THashMap<TMetaVar, Var> vars = new THashMap();
    ArrayDeque<Var> dirtyQueue = new ArrayDeque();
    TypeUnparsingContext tuc = new TypeUnparsingContext();
    ArrayList<TMetaVar> aVars = new ArrayList();
    ArrayList<TMetaVar> bVars = new ArrayList();

    public SubSolver(ErrorLog errorLog, ArrayList<Subsumption> subsumptions, ArrayList<Type> potentialSingletonEffects, long globalLoc) {
        this.errorLog = errorLog;
        this.subsumptions = subsumptions;
        this.potentialSingletonEffects = potentialSingletonEffects;
        this.globalLoc = globalLoc;
    }

    public void solve() {
        this.createVar();
        this.reduceChains();
        this.propagateUpperBounds();
        this.checkLowerBounds();
    }

    private void markAllDirty() {
        for (Var v : this.vars.values()) {
            v.markDirty();
        }
    }

    private Var getOrCreateVar(TMetaVar mv) {
        Var var = (Var)this.vars.get((Object)mv);
        if (var == null) {
            var = new Var(mv, mv.toString(this.tuc).substring(1), this);
            this.vars.put((Object)mv, (Object)var);
        }
        return var;
    }

    private void addVar(Type t) {
        if ((t = Types.canonical(t)) instanceof TMetaVar) {
            this.getOrCreateVar((TMetaVar)t);
        } else if (t instanceof TUnion) {
            Type[] typeArray = ((TUnion)t).effects;
            int n = ((TUnion)t).effects.length;
            int n2 = 0;
            while (n2 < n) {
                Type c = typeArray[n2];
                this.addVar(c);
                ++n2;
            }
        }
    }

    private void addSubsumption(long loc, Type a, Type b) {
        int aCons = this.effectIds.toId(a, this.aVars);
        if (!this.aVars.isEmpty()) {
            for (TMetaVar var : this.aVars) {
                this.getOrCreateVar(var).addUpperBound(this.toVUnion(b));
            }
            this.aVars.clear();
        }
        if (aCons != 0) {
            VUnion u = this.toVUnion(b);
            if (u.vars.isEmpty()) {
                this.testSubsumption(loc, aCons, u.con);
            } else {
                u.makeLowerBound(aCons);
            }
        }
    }

    private VUnion toVUnion(Type a) {
        int cons = this.effectIds.toId(a, this.bVars);
        ArrayList<Var> vars = new ArrayList<Var>(this.bVars.size());
        for (TMetaVar v : this.bVars) {
            vars.add(this.getOrCreateVar(v));
        }
        this.bVars.clear();
        return new VUnion(cons, vars);
    }

    private void createVar() {
        for (Subsumption sub : this.subsumptions) {
            this.addSubsumption(sub.loc, sub.a, sub.b);
        }
        for (Type t : this.potentialSingletonEffects) {
            this.addVar(t);
        }
    }

    private void reduceChains() {
        Var v;
        this.markAllDirty();
        while ((v = this.dirtyQueue.poll()) != null) {
            this.reduceChains(v);
            v.dirty = false;
        }
    }

    private void reduceChains(Var v) {
        if (v.constLowerBound == v.constUpperBound) {
            v.replaceWith(v.constLowerBound);
            return;
        }
        Polarity p = v.original.getPolarity();
        if (!p.isNegative() && v.complexLowerBounds.isEmpty()) {
            if (v.simpleLowerBounds.isEmpty()) {
                if ((v.constLowerBound & v.constUpperBound) != v.constLowerBound) {
                    this.errorLog.log(this.globalLoc, "Subsumption failed.");
                }
                v.replaceWith(v.constLowerBound);
                return;
            }
            if (v.simpleLowerBounds.size() == 1 && v.constLowerBound == 0) {
                v.replaceDownwards(v.simpleLowerBounds.get(0));
                return;
            }
        }
        if (p == Polarity.NEGATIVE && v.complexUpperBounds.isEmpty()) {
            if (v.simpleUpperBounds.isEmpty()) {
                if ((v.constLowerBound & v.constUpperBound) != v.constLowerBound) {
                    this.errorLog.log(this.globalLoc, "Subsumption failed.");
                }
                v.replaceWith(v.constUpperBound);
                return;
            }
            if (v.simpleUpperBounds.size() == 1 && v.constUpperBound == -1) {
                v.replaceUpwards(v.simpleUpperBounds.get(0));
                return;
            }
        }
    }

    private void propagateUpperBounds() {
        Var v;
        this.markAllDirty();
        while ((v = this.dirtyQueue.poll()) != null) {
            int upperApprox = v.constUpperBound;
            for (Var var : v.simpleUpperBounds) {
                upperApprox &= var.upperApprox;
            }
            for (VUnion vUnion : v.complexUpperBounds) {
                upperApprox &= vUnion.getUpperApprox();
            }
            if (upperApprox != v.upperApprox) {
                v.upperApprox = upperApprox;
                for (Var var : v.simpleLowerBounds) {
                    var.markDirty();
                }
                for (VUnion vUnion : v.complexLowerBounds) {
                    if (vUnion.low == null) continue;
                    vUnion.low.markDirty();
                }
            }
            v.dirty = false;
        }
    }

    private void checkLowerBounds() {
        THashSet lowerBounds = new THashSet();
        for (Var v : this.vars.values()) {
            if ((v.constLowerBound & v.upperApprox) != v.constLowerBound) {
                this.testSubsumption(this.globalLoc, v.constLowerBound, v.upperApprox);
            }
            for (VUnion u : v.complexLowerBounds) {
                if (u.low != null) continue;
                lowerBounds.add((Object)u);
            }
        }
        for (VUnion u : lowerBounds) {
            if (u.getUpperApprox() == -1) continue;
            this.errorLog.log(this.globalLoc, "Subsumption failed.");
        }
    }

    private void errorFromUnsolvedEquations() {
        for (Var v : this.vars.values()) {
            if (v.isFree()) continue;
            this.errorLog.log(this.globalLoc, "Couldn't simplify all effect subsumptions away. The current compiler cannot handle this situation. Try adding more type annotations.");
            break;
        }
    }

    private void print() {
        for (Var v : this.vars.values()) {
            System.out.println(v.name + ", " + String.valueOf((Object)v.original.getPolarity()) + (String)(v.simpleLowerBounds.isEmpty() ? "" : ", simpleLowerRefs: " + v.simpleLowerBounds.size()) + (String)(v.complexLowerBounds.isEmpty() ? "" : ", complexLowerRefs: " + v.complexLowerBounds.size()) + ", " + String.valueOf(v.original.getKind()));
            if (v.constLowerBound != 0) {
                System.out.println("    > " + v.constLowerBound);
            }
            if (v.constUpperBound != -1) {
                System.out.println("    < " + v.constUpperBound);
            }
            for (Var var : v.simpleUpperBounds) {
                System.out.println("    < " + var.name);
            }
            for (VUnion vUnion : v.complexUpperBounds) {
                System.out.println("    << " + String.valueOf(vUnion));
            }
        }
    }

    private void printSubsumptions() {
        for (Subsumption sub : this.subsumptions) {
            System.out.println("[" + sub.a.toString(this.tuc) + " < " + sub.b.toString(this.tuc) + " : " + Locations.beginOf(sub.loc) + "," + Locations.endOf(sub.loc) + "]");
        }
    }

    private void testSubsumption(long location, int a, int b) {
        int extraEffects = a & ~b;
        if (extraEffects != 0) {
            this.subsumptionFailed(location, extraEffects);
        }
    }

    private void subsumptionFailed(long location, int effects) {
        this.errorLog.log(location, "Side-effect " + String.valueOf(this.effectIds.toType(effects)) + " is forbidden here.");
    }
}

