/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public class ExpressionConstraint
extends QueryConstraint {
    Variable variable;
    Expression expression;
    boolean isPattern;
    long forwardVariableMask;
    long backwardVariableMask;
    ArrayList<Variable> globalVariables;

    public ExpressionConstraint(ConstraintCollectionContext context, Variable variable, Expression expression, boolean isPattern) {
        this.variable = variable;
        this.expression = expression;
        this.isPattern = isPattern;
        TIntHashSet vars = new TIntHashSet();
        expression.collectVars(context.getVariableMap(), vars);
        int var1 = context.variableMap.get((Object)variable);
        vars.add(var1);
        this.backwardVariableMask = 1L << var1;
        int[] nArray = this.variables = vars.toArray();
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            this.forwardVariableMask |= 1L << v;
            ++n2;
        }
        this.forwardVariableMask ^= this.backwardVariableMask;
        this.globalVariables = context.variables;
    }

    private boolean canBeSolvedForwards(long boundVariables) {
        return (this.forwardVariableMask & boundVariables) == this.forwardVariableMask;
    }

    private boolean canBeSolvedBackwards(long boundVariables) {
        return (this.backwardVariableMask & boundVariables) == this.backwardVariableMask;
    }

    @Override
    public boolean canBeSolvedFrom(long boundVariables) {
        return this.canBeSolvedForwards(boundVariables) || this.isPattern && this.canBeSolvedBackwards(boundVariables);
    }

    @Override
    public double getSolutionCost(long boundVariables) {
        return 1.0;
    }

    @Override
    public double getSolutionBranching(long boundVariables) {
        if (this.canBeSolvedForwards(boundVariables)) {
            return (boundVariables & 1L) == 0L ? 1.0 : 0.95;
        }
        if (this.isPattern && this.canBeSolvedBackwards(boundVariables)) {
            return 0.95;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void generate(final QueryCompilationContext context) {
        if (this.canBeSolvedForwards(this.finalBoundVariables)) {
            if (this.canBeSolvedBackwards(this.finalBoundVariables)) {
                context.equalityCondition(this.expression.location, new EVariable(this.variable), this.expression);
            } else {
                context.let(this.variable, this.expression);
            }
        } else if (this.canBeSolvedBackwards(this.finalBoundVariables)) {
            Expression pattern = this.expression;
            long mask = this.forwardVariableMask & this.finalBoundVariables;
            THashMap map = new THashMap();
            if (mask != 0L) {
                int[] nArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    int variableId = nArray[n2];
                    if ((mask >> variableId & 1L) == 1L) {
                        Variable original = this.globalVariables.get(variableId);
                        Variable newVariable = new Variable(original.getName() + "_temp", original.getType());
                        map.put((Object)original, (Object)new EVariable(newVariable));
                    }
                    ++n2;
                }
                ReplaceContext replaceContext = new ReplaceContext((THashMap<TVar, Type>)new THashMap(0), (THashMap<Variable, Expression>)map, context.getTypingContext());
                pattern = pattern.replace(replaceContext);
            }
            context.match(pattern, new EVariable(this.variable), true);
            map.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<Variable, Expression>(){

                public boolean execute(Variable a, Expression b) {
                    context.equalityCondition(9223372034707292160L, new EVariable(a), b);
                    return true;
                }
            });
        } else {
            throw new InternalCompilerError(this.expression.location, "Error happened when tried to solve the query.");
        }
    }
}

