/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.pre.QPreExists;
import org.simantics.scl.compiler.elaboration.query.pre.QPreGuard;

public abstract class QAbstractCombiner
extends Query {
    public Query[] queries;

    public QAbstractCombiner(Query[] queries) {
        this.queries = queries;
    }

    @Override
    public Query resolve(TranslationContext context) {
        QPreExists modifiedQuery = this.handleExistsStatement(context);
        if (modifiedQuery != null) {
            return ((Query)modifiedQuery).resolve(context);
        }
        int i = 0;
        while (i < this.queries.length) {
            this.queries[i] = this.queries[i].resolve(context);
            ++i;
        }
        return this;
    }

    private QPreExists handleExistsStatement(TranslationContext context) {
        if (this.queries.length == 0) {
            return null;
        }
        if (!(this.queries[0] instanceof QPreGuard)) {
            return null;
        }
        Expression exp = ((QPreGuard)this.queries[0]).guard;
        if (!(exp instanceof EApply)) {
            return null;
        }
        EApply apply = (EApply)exp;
        if (!(apply.getFunction() instanceof EVar)) {
            return null;
        }
        if (!((EVar)apply.getFunction()).name.equals("exists")) {
            return null;
        }
        this.queries = Arrays.copyOfRange(this.queries, 1, this.queries.length);
        Expression[] pars = apply.getParameters();
        String[] variableNames = new String[pars.length];
        int i = 0;
        while (i < pars.length) {
            if (!(pars[i] instanceof EVar)) {
                context.getErrorLog().log(pars[i].getLocation(), "Exists statement may only contain variables as parameters.");
                return null;
            }
            variableNames[i] = ((EVar)pars[i]).name;
            ++i;
        }
        return new QPreExists(variableNames, this);
    }

    @Override
    public void checkType(TypingContext context) {
        Query[] queryArray = this.queries;
        int n = this.queries.length;
        int n2 = 0;
        while (n2 < n) {
            Query query = queryArray[n2];
            query.checkType(context);
            ++n2;
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Query[] queryArray = this.queries;
            int n = this.queries.length;
            int n2 = 0;
            while (n2 < n) {
                Query query = queryArray[n2];
                query.setLocationDeep(loc);
                ++n2;
            }
        }
    }
}

