/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.block.BlockType;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementGroup;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementVisitor;

public class BindStatement
extends Statement {
    public Expression pattern;
    public Expression value;

    public BindStatement(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in) {
        return new EBind(this.location, blockType, this.pattern, this.value, in);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.pattern.setLocationDeep(loc);
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void resolvePattern(TranslationContext context) {
        this.pattern = this.pattern.resolveAsPattern(context);
    }

    @Override
    public boolean mayBeRecursive() {
        return false;
    }

    @Override
    public Statement replace(ReplaceContext context) {
        return new BindStatement(this.pattern.replaceInPattern(context), this.value.replace(context));
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StatementGroup getStatementGroup() {
        return null;
    }
}

