/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.list.CompiledQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EListComprehension
extends SimplifiableExpression {
    public Expression head;
    public ListQualifier qualifier;

    public EListComprehension(Expression head, ListQualifier qualifier) {
        this.head = head;
        this.qualifier = qualifier;
    }

    public EListComprehension(long loc, Expression head, ListQualifier qualifier) {
        super(loc);
        this.head = head;
        this.qualifier = qualifier;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        Type componentType;
        this.qualifier.checkType(context);
        try {
            componentType = Types.unifyApply(Types.LIST, requiredType);
        }
        catch (MatchException matchException) {
            context.getErrorLog().log(this.location, "Expected a value with type " + String.valueOf(requiredType) + " but got a list.");
            return new EError(this.location);
        }
        this.head = this.head.checkType(context, componentType);
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.list(this.head.getType()));
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        context.pushLocation(this.location);
        try {
            CompiledQualifier cq = this.qualifier.compile(context);
            Expression exp = context.mapList(context.lambda(cq.pattern, this.head), cq.value);
            Expression expression = exp = exp.simplify(context);
            return expression;
        }
        finally {
            context.popLocation();
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushFrame();
        this.qualifier.resolve(context);
        this.head = this.head.resolve(context);
        context.popFrame();
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.head.setLocationDeep(loc);
            this.qualifier.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

