/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaConstructor;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.internal.codegen.chr.CHRRuntimeRulesetCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAObject;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class CHRRulesetObject
extends SSAObject {
    CHRRuleset ruleset;
    public BoundVar this_;
    public BoundVar[] parameters;
    public TObjectIntHashMap<BoundVar> parameterIndexMap;
    public TypeDesc[] parameterTypeDescs;

    public CHRRulesetObject(BoundVar target, CHRRuleset ruleset) {
        super(ruleset.runtimeRulesetType);
        this.setTarget(target);
        this.ruleset = ruleset;
    }

    @Override
    public Constant liftClosure(BoundVar newTarget, BoundVar[] parameters) {
        this.ruleset.rulesetObject = this;
        this.this_ = newTarget;
        this.parameters = parameters;
        this.parameterIndexMap = new TObjectIntHashMap(parameters.length);
        int i = 0;
        while (i < parameters.length) {
            this.parameterIndexMap.put((Object)parameters[i], i);
            ++i;
        }
        return new JavaConstructor(this.ruleset.runtimeRulesetClassName, (Type)Types.PROC, (Type)this.ruleset.runtimeRulesetType, Types.getTypes(parameters));
    }

    @Override
    public void generateCode(ModuleBuilder moduleBuilder) {
        CHRRuntimeRulesetCodeGenerator.generateRuntimeRuleset(moduleBuilder, this.ruleset);
    }

    public void realizeMethod(MethodBuilder mb, final ParameterDefiner loader, SSAFunction function, LocalVariable this_, LocalVariable ... callParameters) {
        mb.setLocalVariable(this.this_, this_);
        BoundVar[] functionParameters = function.getParameters();
        if (functionParameters.length != callParameters.length) {
            throw new InternalCompilerError();
        }
        int i = 0;
        while (i < callParameters.length) {
            mb.setLocalVariable(functionParameters[i], callParameters[i]);
            ++i;
        }
        TIntHashSet usedParameterIndices = new TIntHashSet(this.parameters.length);
        function.forValRefs(valRef -> {
            Val binding = valRef.getBinding();
            if (this.parameterIndexMap.containsKey((Object)binding)) {
                usedParameterIndices.add(this.parameterIndexMap.get((Object)((BoundVar)binding)));
            }
        });
        usedParameterIndices.forEach(new TIntProcedure(){

            public boolean execute(int i) {
                loader.defineParameter(i, CHRRulesetObject.this.parameters[i]);
                return true;
            }
        });
        function.markGenerateOnFly();
        function.generateCodeWithAlreadyPreparedParameters(mb);
    }

    @FunctionalInterface
    public static interface ParameterDefiner {
        public void defineParameter(int var1, BoundVar var2);
    }
}

