package org.simantics.scl.compiler.parser.grammar;

import org.simantics.scl.compiler.parser.regexp.Regexp;

import gnu.trove.map.hash.TIntByteHashMap;

public class Production {
    public final String name;
    public int lhs;
    public final Regexp rhs;
    public final TIntByteHashMap annotations;
    
    public Production(String name, int lhs, Regexp rhs,
            TIntByteHashMap annotations) {
        this.name = name;
        this.lhs = lhs;
        this.rhs = rhs;
        this.annotations = annotations;
    }

    public String toString(Grammar grammar) {
        StringBuilder b = new StringBuilder();
        b.append(grammar.getName(lhs));
        b.append(" = ");
        rhs.toString(b, grammar, 0);
        return b.toString();
    }
}
