package org.simantics.scl.compiler.module.options;

import java.io.IOException;
import java.io.ObjectInput;

import org.simantics.scl.compiler.compilation.SCLCompiler;
import org.simantics.scl.compiler.compilation.StoredModule;
import org.simantics.scl.compiler.elaboration.java.ExternalConstantReader;
import org.simantics.scl.compiler.elaboration.java.JavaExternalConstantReader;

public class DefaultStoredModuleSupport implements StoredModuleSupport {

	private JavaExternalConstantReader constantReader = new JavaExternalConstantReader();
	
	@Override
	public ClassLoader getClassLoader(String key) {
		return SCLCompiler.class.getClassLoader();
	}

	@Override
	public String getClassLoaderKey(ClassLoader loader) {
		return "";
	}
	
	public ClassLoader defaultClassLoader() {
		return ModuleCompilationOptions.class.getClassLoader();
	}
	
	@Override
	public ExternalConstantReader getExternalConstantReader() {
		return constantReader;
	}
	
	@Override
	public StoredModule readModule(ObjectInput in) throws IOException, ClassNotFoundException {
		return (StoredModule)in.readObject();
	}
	
}
