package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;



public class TEffectAst extends TypeAst {
    public final TypeAst effect;
    public final TypeAst type;
    
    public TEffectAst(TypeAst effect, TypeAst type) {
        this.effect = effect;
        this.type = type;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('<');
        effect.toString(b);
        b.append("> ");
        b.append(type);
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}
