package org.simantics.scl.compiler.internal.parsing.parser;

import java.io.Reader;
import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.expressions.EBlock;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.module.ImportDeclaration;

public class SCLBlockParser extends SCLParserImpl {

    public final ArrayList<ImportDeclaration> imports = new ArrayList<ImportDeclaration>(2);
    public final EBlock block = new EBlock();
    
    public SCLBlockParser(Reader reader) {
        super(reader);
    }
    
    @Override
    protected Object reduceStatementCommand() {
        Statement statement = (Statement)get(0);
        block.addStatement(statement);
        return null;
    }
    
    @Override
    protected Object reduceImportCommand() {
        ImportDeclaration importDeclaration = (ImportDeclaration)get(0);
        imports.add(importDeclaration);
        return null;
    }

}
