package org.simantics.scl.compiler.internal.parsing.declarations;

import org.simantics.scl.compiler.internal.parsing.types.TypeAst;


public class DTypeAst extends DeclarationAst {
    public final String name;
    public final String[] parameters;
    public final TypeAst type;
    
    public DTypeAst(String name, String[] parameters, TypeAst type) {
        this.name = name;
        this.parameters = parameters;
        this.type = type;
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("type ");
        b.append(name);
        for(String parameter : parameters) {
            b.append(' ');
            b.append(parameter);
        }
        b.append(" = ");
        type.toString(b);
    }
}
