package org.simantics.scl.compiler.internal.codegen.writer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import org.simantics.scl.compiler.elaboration.java.ExternalConstantReader;

public class ExternalConstant implements Externalizable {
	
    public String fieldName;
    public Object value;

    public ExternalConstant() {
    }

    public ExternalConstant(String fieldName, Object value) {
        this.fieldName = fieldName;
        this.value = value;
    }

	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeUTF(fieldName);
		ExternalConstantReader reader = ExternalConstantReader.getInstance();
		reader.writeExternal(out, value);
	}

	@Override
	public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		fieldName = in.readUTF();
		ExternalConstantReader reader = ExternalConstantReader.getInstance();
		value = reader.readExternal(in);
	}	
	
}
