package org.simantics.scl.compiler.internal.codegen.effects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.simantics.scl.compiler.types.TCon;

public class EffectConstructor implements Serializable {
    public final TCon name;
    ArrayList<ThreadLocalVariable> threadLocalVariables = 
            new ArrayList<ThreadLocalVariable>();
    
    public EffectConstructor(TCon name) {
        this.name = name;
    }

    public List<ThreadLocalVariable> getThreadLocalVariables() {
        return threadLocalVariables;
    }
    
    public void addThreadLocalVariable(ThreadLocalVariable var) {
        threadLocalVariables.add(var);
    }
}
