package org.simantics.scl.compiler.environment;

import java.util.Collection;
import java.util.List;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.types.TCon;

public enum EmptyEnvironment implements Environment {
    INSTANCE;

    @Override
    public Namespace getLocalNamespace() {
        return EmptyNamespace.INSTANCE;
    }

    @Override
    public SCLValue getValue(Name name) {
        return null;
    }

    @Override
    public List<Constant> getFieldAccessors(String name) {
        return null;
    }

    @Override
    public SCLRelation getRelation(Name name) {
        return null;
    }

    @Override
    public SCLEntityType getEntityType(Name name) {
        return null;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(TCon type) {
        return null;
    }

    @Override
    public EffectConstructor getEffectConstructor(TCon type) {
        return null;
    }

    @Override
    public TypeClass getTypeClass(TCon type) {
        return null;
    }

    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        return null;
    }

    @Override
    public void collectRules(Collection<TransformationRule> rules) {
    }
}
