package org.simantics.scl.compiler.elaboration.query.pre;

import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.errors.Locations;

public class QPreExists extends PreQuery {
    String[] variables;
    public Query query;
    
    public QPreExists(String[] variables, Query query) {
        this.variables = variables;
        this.query = query;
    }

    @Override
    public Query resolve(TranslationContext context) {
        context.pushFrame();
        Variable[] newVariables = new Variable[variables.length];
        for(int i=0;i<variables.length;++i)
            newVariables[i] = context.newVariable(variables[i]);
        Query newQuery = query.resolve(context);
        context.popFrame();
        
        QExists result = new QExists(newVariables, newQuery);
        result.location = location;
        return result;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            query.setLocationDeep(loc);
        }
    }
    
    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
}
