package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Opcodes;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.runtime.profiling.BranchPoint;

public class VisitBranchPoint extends FunctionValue {
    public static final VisitBranchPoint INSTANCE = new VisitBranchPoint();
    
    private static final String CLASS_NAME =
            BranchPoint.class.getCanonicalName().replace('.', '/');
    private static final String FIELD_NAME = "visitCounter";
    
    private VisitBranchPoint() {
        super(TVar.EMPTY_ARRAY, Types.PROC, Types.UNIT, Types.BRANCH_POINT);
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        parameters[0].push(mb);
        mb.dup();
        mb.loadField(CLASS_NAME, FIELD_NAME, TypeDesc.INT);
        mb.loadConstant(1);
        mb.math(Opcodes.IADD);
        mb.storeField(CLASS_NAME, FIELD_NAME, TypeDesc.INT);
        return Types.UNIT;
    }
    
    @Override
    public String toString() {
        return "visitBranchPoint";
    }
}
