package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.AbstractRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EqRelation extends AbstractRelation {
    public static final EqRelation INSTANCE = new EqRelation();
    
    private EqRelation() {}
    
    private static final TVar A = Types.var(Kinds.STAR);
    
    private static final TVar[] TYPE_VARIABLES = new TVar[] {A};
    
    @Override
    public TVar[] getTypeVariables() {
        return TYPE_VARIABLES;
    }

    private static final Type[] PARAMETER_TYPES = new Type[] {A, A};
    
    @Override
    public Type[] getParameterTypes() {
        return PARAMETER_TYPES;
    }
    
    @Override
    public int getPhase() {
        return 0;
    }
    
    @Override
    public double getSelectivity(int boundVariables) {
        switch(boundVariables) {
        case FF: return Double.POSITIVE_INFINITY;
        case BF:
        case FB: return 1.0;
        case BB: return 0.1;
        default: throw new IllegalArgumentException();
        }
    }
    
    @Override
    public int getRequiredVariablesMask() {
        return FF;
    }

    @Override
    public void generate(long location,
            QueryCompilationContext context,
            Type[] typeParameters, Variable[] parameters, int boundVariables) {
        switch(boundVariables) {
        case BF:
            context.let(parameters[1], new EVariable(parameters[0]));
            break;
        case FB:
            context.let(parameters[0], new EVariable(parameters[1]));
            break;
        case BB:            
            context.equalityCondition(location, 
                        new EVariable(parameters[0]),
                        new EVariable(parameters[1]));
            break;
        default: throw new IllegalArgumentException();
        }
    }

    @Override
    public String toString() {
        return "=";
    }

    @Override
    public Type getEnforceEffect() {
        return Types.NO_EFFECTS;
    }

    @Override
    public Type getQueryEffect() {
        return Types.NO_EFFECTS;
    }
}
